# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.checks_create_request_output_annotations_inner import ChecksCreateRequestOutputAnnotationsInner
from devopso.clients.github.models.checks_create_request_output_images_inner import ChecksCreateRequestOutputImagesInner
from typing import Optional, Set
from typing_extensions import Self

class ChecksCreateRequestOutput(BaseModel):
    """
    Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.
    """ # noqa: E501
    title: StrictStr = Field(description="The title of the check run.")
    summary: Annotated[str, Field(strict=True, max_length=65535)] = Field(description="The summary of the check run. This parameter supports Markdown. **Maximum length**: 65535 characters.")
    text: Optional[Annotated[str, Field(strict=True, max_length=65535)]] = Field(default=None, description="The details of the check run. This parameter supports Markdown. **Maximum length**: 65535 characters.")
    annotations: Optional[Annotated[List[ChecksCreateRequestOutputAnnotationsInner], Field(max_length=50)]] = Field(default=None, description="Adds information from your analysis to specific lines of code. Annotations are visible on GitHub in the **Checks** and **Files changed** tab of the pull request. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/checks/runs#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. GitHub Actions are limited to 10 warning annotations and 10 error annotations per step. For details about how you can view annotations on GitHub, see \"[About status checks](https://docs.github.com/articles/about-status-checks#checks)\".")
    images: Optional[List[ChecksCreateRequestOutputImagesInner]] = Field(default=None, description="Adds images to the output displayed in the GitHub pull request UI.")
    __properties: ClassVar[List[str]] = ["title", "summary", "text", "annotations", "images"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChecksCreateRequestOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in annotations (list)
        _items = []
        if self.annotations:
            for _item_annotations in self.annotations:
                if _item_annotations:
                    _items.append(_item_annotations.to_dict())
            _dict['annotations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item_images in self.images:
                if _item_images:
                    _items.append(_item_images.to_dict())
            _dict['images'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChecksCreateRequestOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "summary": obj.get("summary"),
            "text": obj.get("text"),
            "annotations": [ChecksCreateRequestOutputAnnotationsInner.from_dict(_item) for _item in obj["annotations"]] if obj.get("annotations") is not None else None,
            "images": [ChecksCreateRequestOutputImagesInner.from_dict(_item) for _item in obj["images"]] if obj.get("images") is not None else None
        })
        return _obj


