# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ChecksCreateRequestOutputAnnotationsInner(BaseModel):
    """
    ChecksCreateRequestOutputAnnotationsInner
    """ # noqa: E501
    path: StrictStr = Field(description="The path of the file to add an annotation to. For example, `assets/css/main.css`.")
    start_line: StrictInt = Field(description="The start line of the annotation. Line numbers start at 1.")
    end_line: StrictInt = Field(description="The end line of the annotation.")
    start_column: Optional[StrictInt] = Field(default=None, description="The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values. Column numbers start at 1.")
    end_column: Optional[StrictInt] = Field(default=None, description="The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.")
    annotation_level: StrictStr = Field(description="The level of the annotation.")
    message: StrictStr = Field(description="A short description of the feedback for these lines of code. The maximum size is 64 KB.")
    title: Optional[StrictStr] = Field(default=None, description="The title that represents the annotation. The maximum size is 255 characters.")
    raw_details: Optional[StrictStr] = Field(default=None, description="Details about this annotation. The maximum size is 64 KB.")
    __properties: ClassVar[List[str]] = ["path", "start_line", "end_line", "start_column", "end_column", "annotation_level", "message", "title", "raw_details"]

    @field_validator('annotation_level')
    def annotation_level_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['notice', 'warning', 'failure']):
            raise ValueError("must be one of enum values ('notice', 'warning', 'failure')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChecksCreateRequestOutputAnnotationsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChecksCreateRequestOutputAnnotationsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "path": obj.get("path"),
            "start_line": obj.get("start_line"),
            "end_line": obj.get("end_line"),
            "start_column": obj.get("start_column"),
            "end_column": obj.get("end_column"),
            "annotation_level": obj.get("annotation_level"),
            "message": obj.get("message"),
            "title": obj.get("title"),
            "raw_details": obj.get("raw_details")
        })
        return _obj


