# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ClassroomAssignmentGrade(BaseModel):
    """
    Grade for a student or groups GitHub Classroom assignment
    """ # noqa: E501
    assignment_name: StrictStr = Field(description="Name of the assignment")
    assignment_url: StrictStr = Field(description="URL of the assignment")
    starter_code_url: StrictStr = Field(description="URL of the starter code for the assignment")
    github_username: StrictStr = Field(description="GitHub username of the student")
    roster_identifier: StrictStr = Field(description="Roster identifier of the student")
    student_repository_name: StrictStr = Field(description="Name of the student's assignment repository")
    student_repository_url: StrictStr = Field(description="URL of the student's assignment repository")
    submission_timestamp: StrictStr = Field(description="Timestamp of the student's assignment submission")
    points_awarded: StrictInt = Field(description="Number of points awarded to the student")
    points_available: StrictInt = Field(description="Number of points available for the assignment")
    group_name: Optional[StrictStr] = Field(default=None, description="If a group assignment, name of the group the student is in")
    __properties: ClassVar[List[str]] = ["assignment_name", "assignment_url", "starter_code_url", "github_username", "roster_identifier", "student_repository_name", "student_repository_url", "submission_timestamp", "points_awarded", "points_available", "group_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClassroomAssignmentGrade from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClassroomAssignmentGrade from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignment_name": obj.get("assignment_name"),
            "assignment_url": obj.get("assignment_url"),
            "starter_code_url": obj.get("starter_code_url"),
            "github_username": obj.get("github_username"),
            "roster_identifier": obj.get("roster_identifier"),
            "student_repository_name": obj.get("student_repository_name"),
            "student_repository_url": obj.get("student_repository_url"),
            "submission_timestamp": obj.get("submission_timestamp"),
            "points_awarded": obj.get("points_awarded"),
            "points_available": obj.get("points_available"),
            "group_name": obj.get("group_name")
        })
        return _obj


