# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.code_scanning_alert_classification import CodeScanningAlertClassification
from devopso.clients.github.models.code_scanning_alert_instance_message import CodeScanningAlertInstanceMessage
from devopso.clients.github.models.code_scanning_alert_location import CodeScanningAlertLocation
from devopso.clients.github.models.code_scanning_alert_state import CodeScanningAlertState
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningAlertInstance(BaseModel):
    """
    CodeScanningAlertInstance
    """ # noqa: E501
    ref: Optional[StrictStr] = Field(default=None, description="The Git reference, formatted as `refs/pull/<number>/merge`, `refs/pull/<number>/head`, `refs/heads/<branch name>` or simply `<branch name>`.")
    analysis_key: Optional[StrictStr] = Field(default=None, description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.")
    environment: Optional[StrictStr] = Field(default=None, description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.")
    category: Optional[StrictStr] = Field(default=None, description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.")
    state: Optional[CodeScanningAlertState] = None
    commit_sha: Optional[StrictStr] = None
    message: Optional[CodeScanningAlertInstanceMessage] = None
    location: Optional[CodeScanningAlertLocation] = None
    html_url: Optional[StrictStr] = None
    classifications: Optional[List[Optional[CodeScanningAlertClassification]]] = Field(default=None, description="Classifications that have been applied to the file that triggered the alert. For example identifying it as documentation, or a generated file.")
    __properties: ClassVar[List[str]] = ["ref", "analysis_key", "environment", "category", "state", "commit_sha", "message", "location", "html_url", "classifications"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningAlertInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningAlertInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ref": obj.get("ref"),
            "analysis_key": obj.get("analysis_key"),
            "environment": obj.get("environment"),
            "category": obj.get("category"),
            "state": obj.get("state"),
            "commit_sha": obj.get("commit_sha"),
            "message": CodeScanningAlertInstanceMessage.from_dict(obj["message"]) if obj.get("message") is not None else None,
            "location": CodeScanningAlertLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "html_url": obj.get("html_url"),
            "classifications": obj.get("classifications")
        })
        return _obj


