# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningAnalysisDeletion(BaseModel):
    """
    Successful deletion of a code scanning analysis
    """ # noqa: E501
    next_analysis_url: Optional[StrictStr] = Field(description="Next deletable analysis in chain, without last analysis deletion confirmation")
    confirm_delete_url: Optional[StrictStr] = Field(description="Next deletable analysis in chain, with last analysis deletion confirmation")
    __properties: ClassVar[List[str]] = ["next_analysis_url", "confirm_delete_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningAnalysisDeletion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "next_analysis_url",
            "confirm_delete_url",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if next_analysis_url (nullable) is None
        # and model_fields_set contains the field
        if self.next_analysis_url is None and "next_analysis_url" in self.model_fields_set:
            _dict['next_analysis_url'] = None

        # set to None if confirm_delete_url (nullable) is None
        # and model_fields_set contains the field
        if self.confirm_delete_url is None and "confirm_delete_url" in self.model_fields_set:
            _dict['confirm_delete_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningAnalysisDeletion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "next_analysis_url": obj.get("next_analysis_url"),
            "confirm_delete_url": obj.get("confirm_delete_url")
        })
        return _obj


