# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningCodeqlDatabase(BaseModel):
    """
    A CodeQL database.
    """ # noqa: E501
    id: StrictInt = Field(description="The ID of the CodeQL database.")
    name: StrictStr = Field(description="The name of the CodeQL database.")
    language: StrictStr = Field(description="The language of the CodeQL database.")
    uploader: SimpleUser
    content_type: StrictStr = Field(description="The MIME type of the CodeQL database file.")
    size: StrictInt = Field(description="The size of the CodeQL database file in bytes.")
    created_at: datetime = Field(description="The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    updated_at: datetime = Field(description="The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    url: StrictStr = Field(description="The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.")
    commit_oid: Optional[StrictStr] = Field(default=None, description="The commit SHA of the repository at the time the CodeQL database was created.")
    __properties: ClassVar[List[str]] = ["id", "name", "language", "uploader", "content_type", "size", "created_at", "updated_at", "url", "commit_oid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningCodeqlDatabase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of uploader
        if self.uploader:
            _dict['uploader'] = self.uploader.to_dict()
        # set to None if commit_oid (nullable) is None
        # and model_fields_set contains the field
        if self.commit_oid is None and "commit_oid" in self.model_fields_set:
            _dict['commit_oid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningCodeqlDatabase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "language": obj.get("language"),
            "uploader": SimpleUser.from_dict(obj["uploader"]) if obj.get("uploader") is not None else None,
            "content_type": obj.get("content_type"),
            "size": obj.get("size"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url"),
            "commit_oid": obj.get("commit_oid")
        })
        return _obj


