# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningDefaultSetupUpdate(BaseModel):
    """
    Configuration for code scanning default setup.
    """ # noqa: E501
    state: Optional[StrictStr] = Field(default=None, description="The desired state of code scanning default setup.")
    runner_type: Optional[StrictStr] = Field(default=None, description="Runner type to be used.")
    runner_label: Optional[StrictStr] = Field(default=None, description="Runner label to be used if the runner type is labeled.")
    query_suite: Optional[StrictStr] = Field(default=None, description="CodeQL query suite to be used.")
    threat_model: Optional[StrictStr] = Field(default=None, description="Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.")
    languages: Optional[List[StrictStr]] = Field(default=None, description="CodeQL languages to be analyzed.")
    __properties: ClassVar[List[str]] = ["state", "runner_type", "runner_label", "query_suite", "threat_model", "languages"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['configured', 'not-configured']):
            raise ValueError("must be one of enum values ('configured', 'not-configured')")
        return value

    @field_validator('runner_type')
    def runner_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['standard', 'labeled']):
            raise ValueError("must be one of enum values ('standard', 'labeled')")
        return value

    @field_validator('query_suite')
    def query_suite_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['default', 'extended']):
            raise ValueError("must be one of enum values ('default', 'extended')")
        return value

    @field_validator('threat_model')
    def threat_model_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['remote', 'remote_and_local']):
            raise ValueError("must be one of enum values ('remote', 'remote_and_local')")
        return value

    @field_validator('languages')
    def languages_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['actions', 'c-cpp', 'csharp', 'go', 'java-kotlin', 'javascript-typescript', 'python', 'ruby', 'swift']):
                raise ValueError("each list item must be one of ('actions', 'c-cpp', 'csharp', 'go', 'java-kotlin', 'javascript-typescript', 'python', 'ruby', 'swift')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningDefaultSetupUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if runner_label (nullable) is None
        # and model_fields_set contains the field
        if self.runner_label is None and "runner_label" in self.model_fields_set:
            _dict['runner_label'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningDefaultSetupUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "runner_type": obj.get("runner_type"),
            "runner_label": obj.get("runner_label"),
            "query_suite": obj.get("query_suite"),
            "threat_model": obj.get("threat_model"),
            "languages": obj.get("languages")
        })
        return _obj


