# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.code_scanning_alert_dismissed_reason import CodeScanningAlertDismissedReason
from devopso.clients.github.models.code_scanning_alert_instance import CodeScanningAlertInstance
from devopso.clients.github.models.code_scanning_alert_rule_summary import CodeScanningAlertRuleSummary
from devopso.clients.github.models.code_scanning_alert_state import CodeScanningAlertState
from devopso.clients.github.models.code_scanning_analysis_tool import CodeScanningAnalysisTool
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.simple_repository import SimpleRepository
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningOrganizationAlertItems(BaseModel):
    """
    CodeScanningOrganizationAlertItems
    """ # noqa: E501
    number: StrictInt = Field(description="The security alert number.")
    created_at: datetime = Field(description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    updated_at: Optional[datetime] = Field(default=None, description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    url: StrictStr = Field(description="The REST API URL of the alert resource.")
    html_url: StrictStr = Field(description="The GitHub URL of the alert resource.")
    instances_url: StrictStr = Field(description="The REST API URL for fetching the list of instances for an alert.")
    state: Optional[CodeScanningAlertState]
    fixed_at: Optional[datetime] = Field(default=None, description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    dismissed_by: Optional[NullableSimpleUser]
    dismissed_at: Optional[datetime] = Field(description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    dismissed_reason: Optional[CodeScanningAlertDismissedReason]
    dismissed_comment: Optional[Annotated[str, Field(strict=True, max_length=280)]] = Field(default=None, description="The dismissal comment associated with the dismissal of the alert.")
    rule: CodeScanningAlertRuleSummary
    tool: CodeScanningAnalysisTool
    most_recent_instance: CodeScanningAlertInstance
    repository: SimpleRepository
    dismissal_approved_by: Optional[NullableSimpleUser] = None
    assignees: Optional[List[SimpleUser]] = None
    __properties: ClassVar[List[str]] = ["number", "created_at", "updated_at", "url", "html_url", "instances_url", "state", "fixed_at", "dismissed_by", "dismissed_at", "dismissed_reason", "dismissed_comment", "rule", "tool", "most_recent_instance", "repository", "dismissal_approved_by", "assignees"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningOrganizationAlertItems from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "number",
            "created_at",
            "updated_at",
            "url",
            "html_url",
            "instances_url",
            "fixed_at",
            "dismissed_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dismissed_by
        if self.dismissed_by:
            _dict['dismissed_by'] = self.dismissed_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rule
        if self.rule:
            _dict['rule'] = self.rule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tool
        if self.tool:
            _dict['tool'] = self.tool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of most_recent_instance
        if self.most_recent_instance:
            _dict['most_recent_instance'] = self.most_recent_instance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dismissal_approved_by
        if self.dismissal_approved_by:
            _dict['dismissal_approved_by'] = self.dismissal_approved_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in assignees (list)
        _items = []
        if self.assignees:
            for _item_assignees in self.assignees:
                if _item_assignees:
                    _items.append(_item_assignees.to_dict())
            _dict['assignees'] = _items
        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if fixed_at (nullable) is None
        # and model_fields_set contains the field
        if self.fixed_at is None and "fixed_at" in self.model_fields_set:
            _dict['fixed_at'] = None

        # set to None if dismissed_by (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_by is None and "dismissed_by" in self.model_fields_set:
            _dict['dismissed_by'] = None

        # set to None if dismissed_at (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_at is None and "dismissed_at" in self.model_fields_set:
            _dict['dismissed_at'] = None

        # set to None if dismissed_reason (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_reason is None and "dismissed_reason" in self.model_fields_set:
            _dict['dismissed_reason'] = None

        # set to None if dismissed_comment (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_comment is None and "dismissed_comment" in self.model_fields_set:
            _dict['dismissed_comment'] = None

        # set to None if dismissal_approved_by (nullable) is None
        # and model_fields_set contains the field
        if self.dismissal_approved_by is None and "dismissal_approved_by" in self.model_fields_set:
            _dict['dismissal_approved_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningOrganizationAlertItems from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "instances_url": obj.get("instances_url"),
            "state": obj.get("state"),
            "fixed_at": obj.get("fixed_at"),
            "dismissed_by": NullableSimpleUser.from_dict(obj["dismissed_by"]) if obj.get("dismissed_by") is not None else None,
            "dismissed_at": obj.get("dismissed_at"),
            "dismissed_reason": obj.get("dismissed_reason"),
            "dismissed_comment": obj.get("dismissed_comment"),
            "rule": CodeScanningAlertRuleSummary.from_dict(obj["rule"]) if obj.get("rule") is not None else None,
            "tool": CodeScanningAnalysisTool.from_dict(obj["tool"]) if obj.get("tool") is not None else None,
            "most_recent_instance": CodeScanningAlertInstance.from_dict(obj["most_recent_instance"]) if obj.get("most_recent_instance") is not None else None,
            "repository": SimpleRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "dismissal_approved_by": NullableSimpleUser.from_dict(obj["dismissal_approved_by"]) if obj.get("dismissal_approved_by") is not None else None,
            "assignees": [SimpleUser.from_dict(_item) for _item in obj["assignees"]] if obj.get("assignees") is not None else None
        })
        return _obj


