# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.code_scanning_variant_analysis_language import CodeScanningVariantAnalysisLanguage
from devopso.clients.github.models.code_scanning_variant_analysis_scanned_repositories_inner import CodeScanningVariantAnalysisScannedRepositoriesInner
from devopso.clients.github.models.code_scanning_variant_analysis_skipped_repositories import CodeScanningVariantAnalysisSkippedRepositories
from devopso.clients.github.models.simple_repository import SimpleRepository
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningVariantAnalysis(BaseModel):
    """
    A run of a CodeQL query against one or more repositories.
    """ # noqa: E501
    id: StrictInt = Field(description="The ID of the variant analysis.")
    controller_repo: SimpleRepository
    actor: SimpleUser
    query_language: CodeScanningVariantAnalysisLanguage
    query_pack_url: StrictStr = Field(description="The download url for the query pack.")
    created_at: Optional[datetime] = Field(default=None, description="The date and time at which the variant analysis was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    updated_at: Optional[datetime] = Field(default=None, description="The date and time at which the variant analysis was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.")
    completed_at: Optional[datetime] = Field(default=None, description="The date and time at which the variant analysis was completed, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ. Will be null if the variant analysis has not yet completed or this information is not available.")
    status: StrictStr
    actions_workflow_run_id: Optional[StrictInt] = Field(default=None, description="The GitHub Actions workflow run used to execute this variant analysis. This is only available if the workflow run has started.")
    failure_reason: Optional[StrictStr] = Field(default=None, description="The reason for a failure of the variant analysis. This is only available if the variant analysis has failed.")
    scanned_repositories: Optional[List[CodeScanningVariantAnalysisScannedRepositoriesInner]] = None
    skipped_repositories: Optional[CodeScanningVariantAnalysisSkippedRepositories] = None
    __properties: ClassVar[List[str]] = ["id", "controller_repo", "actor", "query_language", "query_pack_url", "created_at", "updated_at", "completed_at", "status", "actions_workflow_run_id", "failure_reason", "scanned_repositories", "skipped_repositories"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['in_progress', 'succeeded', 'failed', 'cancelled']):
            raise ValueError("must be one of enum values ('in_progress', 'succeeded', 'failed', 'cancelled')")
        return value

    @field_validator('failure_reason')
    def failure_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['no_repos_queried', 'actions_workflow_run_failed', 'internal_error']):
            raise ValueError("must be one of enum values ('no_repos_queried', 'actions_workflow_run_failed', 'internal_error')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningVariantAnalysis from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of controller_repo
        if self.controller_repo:
            _dict['controller_repo'] = self.controller_repo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in scanned_repositories (list)
        _items = []
        if self.scanned_repositories:
            for _item_scanned_repositories in self.scanned_repositories:
                if _item_scanned_repositories:
                    _items.append(_item_scanned_repositories.to_dict())
            _dict['scanned_repositories'] = _items
        # override the default output from pydantic by calling `to_dict()` of skipped_repositories
        if self.skipped_repositories:
            _dict['skipped_repositories'] = self.skipped_repositories.to_dict()
        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningVariantAnalysis from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "controller_repo": SimpleRepository.from_dict(obj["controller_repo"]) if obj.get("controller_repo") is not None else None,
            "actor": SimpleUser.from_dict(obj["actor"]) if obj.get("actor") is not None else None,
            "query_language": obj.get("query_language"),
            "query_pack_url": obj.get("query_pack_url"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "completed_at": obj.get("completed_at"),
            "status": obj.get("status"),
            "actions_workflow_run_id": obj.get("actions_workflow_run_id"),
            "failure_reason": obj.get("failure_reason"),
            "scanned_repositories": [CodeScanningVariantAnalysisScannedRepositoriesInner.from_dict(_item) for _item in obj["scanned_repositories"]] if obj.get("scanned_repositories") is not None else None,
            "skipped_repositories": CodeScanningVariantAnalysisSkippedRepositories.from_dict(obj["skipped_repositories"]) if obj.get("skipped_repositories") is not None else None
        })
        return _obj


