# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.code_scanning_variant_analysis_status import CodeScanningVariantAnalysisStatus
from devopso.clients.github.models.simple_repository import SimpleRepository
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningVariantAnalysisRepoTask(BaseModel):
    """
    CodeScanningVariantAnalysisRepoTask
    """ # noqa: E501
    repository: SimpleRepository
    analysis_status: CodeScanningVariantAnalysisStatus
    artifact_size_in_bytes: Optional[StrictInt] = Field(default=None, description="The size of the artifact. This is only available for successful analyses.")
    result_count: Optional[StrictInt] = Field(default=None, description="The number of results in the case of a successful analysis. This is only available for successful analyses.")
    failure_message: Optional[StrictStr] = Field(default=None, description="The reason of the failure of this repo task. This is only available if the repository task has failed.")
    database_commit_sha: Optional[StrictStr] = Field(default=None, description="The SHA of the commit the CodeQL database was built against. This is only available for successful analyses.")
    source_location_prefix: Optional[StrictStr] = Field(default=None, description="The source location prefix to use. This is only available for successful analyses.")
    artifact_url: Optional[StrictStr] = Field(default=None, description="The URL of the artifact. This is only available for successful analyses.")
    __properties: ClassVar[List[str]] = ["repository", "analysis_status", "artifact_size_in_bytes", "result_count", "failure_message", "database_commit_sha", "source_location_prefix", "artifact_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningVariantAnalysisRepoTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningVariantAnalysisRepoTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "repository": SimpleRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "analysis_status": obj.get("analysis_status"),
            "artifact_size_in_bytes": obj.get("artifact_size_in_bytes"),
            "result_count": obj.get("result_count"),
            "failure_message": obj.get("failure_message"),
            "database_commit_sha": obj.get("database_commit_sha"),
            "source_location_prefix": obj.get("source_location_prefix"),
            "artifact_url": obj.get("artifact_url")
        })
        return _obj


