# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.code_scanning_variant_analysis_skipped_repo_group import CodeScanningVariantAnalysisSkippedRepoGroup
from devopso.clients.github.models.code_scanning_variant_analysis_skipped_repositories_not_found_repos import CodeScanningVariantAnalysisSkippedRepositoriesNotFoundRepos
from typing import Optional, Set
from typing_extensions import Self

class CodeScanningVariantAnalysisSkippedRepositories(BaseModel):
    """
    Information about repositories that were skipped from processing. This information is only available to the user that initiated the variant analysis.
    """ # noqa: E501
    access_mismatch_repos: CodeScanningVariantAnalysisSkippedRepoGroup
    not_found_repos: CodeScanningVariantAnalysisSkippedRepositoriesNotFoundRepos
    no_codeql_db_repos: CodeScanningVariantAnalysisSkippedRepoGroup
    over_limit_repos: CodeScanningVariantAnalysisSkippedRepoGroup
    __properties: ClassVar[List[str]] = ["access_mismatch_repos", "not_found_repos", "no_codeql_db_repos", "over_limit_repos"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeScanningVariantAnalysisSkippedRepositories from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access_mismatch_repos
        if self.access_mismatch_repos:
            _dict['access_mismatch_repos'] = self.access_mismatch_repos.to_dict()
        # override the default output from pydantic by calling `to_dict()` of not_found_repos
        if self.not_found_repos:
            _dict['not_found_repos'] = self.not_found_repos.to_dict()
        # override the default output from pydantic by calling `to_dict()` of no_codeql_db_repos
        if self.no_codeql_db_repos:
            _dict['no_codeql_db_repos'] = self.no_codeql_db_repos.to_dict()
        # override the default output from pydantic by calling `to_dict()` of over_limit_repos
        if self.over_limit_repos:
            _dict['over_limit_repos'] = self.over_limit_repos.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeScanningVariantAnalysisSkippedRepositories from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_mismatch_repos": CodeScanningVariantAnalysisSkippedRepoGroup.from_dict(obj["access_mismatch_repos"]) if obj.get("access_mismatch_repos") is not None else None,
            "not_found_repos": CodeScanningVariantAnalysisSkippedRepositoriesNotFoundRepos.from_dict(obj["not_found_repos"]) if obj.get("not_found_repos") is not None else None,
            "no_codeql_db_repos": CodeScanningVariantAnalysisSkippedRepoGroup.from_dict(obj["no_codeql_db_repos"]) if obj.get("no_codeql_db_repos") is not None else None,
            "over_limit_repos": CodeScanningVariantAnalysisSkippedRepoGroup.from_dict(obj["over_limit_repos"]) if obj.get("over_limit_repos") is not None else None
        })
        return _obj


