# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.code_security_configuration_code_scanning_default_setup_options import CodeSecurityConfigurationCodeScanningDefaultSetupOptions
from devopso.clients.github.models.code_security_configuration_code_scanning_options import CodeSecurityConfigurationCodeScanningOptions
from devopso.clients.github.models.code_security_create_configuration_request_secret_scanning_delegated_bypass_options import CodeSecurityCreateConfigurationRequestSecretScanningDelegatedBypassOptions
from devopso.clients.github.models.code_security_update_enterprise_configuration_request_dependency_graph_autosubmit_action_options import CodeSecurityUpdateEnterpriseConfigurationRequestDependencyGraphAutosubmitActionOptions
from typing import Optional, Set
from typing_extensions import Self

class CodeSecurityConfiguration(BaseModel):
    """
    A code security configuration
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The ID of the code security configuration")
    name: Optional[StrictStr] = Field(default=None, description="The name of the code security configuration. Must be unique within the organization.")
    target_type: Optional[StrictStr] = Field(default=None, description="The type of the code security configuration.")
    description: Optional[StrictStr] = Field(default=None, description="A description of the code security configuration")
    advanced_security: Optional[StrictStr] = Field(default=None, description="The enablement status of GitHub Advanced Security")
    dependency_graph: Optional[StrictStr] = Field(default=None, description="The enablement status of Dependency Graph")
    dependency_graph_autosubmit_action: Optional[StrictStr] = Field(default=None, description="The enablement status of Automatic dependency submission")
    dependency_graph_autosubmit_action_options: Optional[CodeSecurityUpdateEnterpriseConfigurationRequestDependencyGraphAutosubmitActionOptions] = None
    dependabot_alerts: Optional[StrictStr] = Field(default=None, description="The enablement status of Dependabot alerts")
    dependabot_security_updates: Optional[StrictStr] = Field(default=None, description="The enablement status of Dependabot security updates")
    code_scanning_options: Optional[CodeSecurityConfigurationCodeScanningOptions] = None
    code_scanning_default_setup: Optional[StrictStr] = Field(default=None, description="The enablement status of code scanning default setup")
    code_scanning_default_setup_options: Optional[CodeSecurityConfigurationCodeScanningDefaultSetupOptions] = None
    code_scanning_delegated_alert_dismissal: Optional[StrictStr] = Field(default=None, description="The enablement status of code scanning delegated alert dismissal")
    secret_scanning: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning")
    secret_scanning_push_protection: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning push protection")
    secret_scanning_delegated_bypass: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning delegated bypass")
    secret_scanning_delegated_bypass_options: Optional[CodeSecurityCreateConfigurationRequestSecretScanningDelegatedBypassOptions] = None
    secret_scanning_validity_checks: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning validity checks")
    secret_scanning_non_provider_patterns: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning non-provider patterns")
    secret_scanning_generic_secrets: Optional[StrictStr] = Field(default=None, description="The enablement status of Copilot secret scanning")
    secret_scanning_delegated_alert_dismissal: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning delegated alert dismissal")
    private_vulnerability_reporting: Optional[StrictStr] = Field(default=None, description="The enablement status of private vulnerability reporting")
    enforcement: Optional[StrictStr] = Field(default=None, description="The enforcement status for a security configuration")
    url: Optional[StrictStr] = Field(default=None, description="The URL of the configuration")
    html_url: Optional[StrictStr] = Field(default=None, description="The URL of the configuration")
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "name", "target_type", "description", "advanced_security", "dependency_graph", "dependency_graph_autosubmit_action", "dependency_graph_autosubmit_action_options", "dependabot_alerts", "dependabot_security_updates", "code_scanning_options", "code_scanning_default_setup", "code_scanning_default_setup_options", "code_scanning_delegated_alert_dismissal", "secret_scanning", "secret_scanning_push_protection", "secret_scanning_delegated_bypass", "secret_scanning_delegated_bypass_options", "secret_scanning_validity_checks", "secret_scanning_non_provider_patterns", "secret_scanning_generic_secrets", "secret_scanning_delegated_alert_dismissal", "private_vulnerability_reporting", "enforcement", "url", "html_url", "created_at", "updated_at"]

    @field_validator('target_type')
    def target_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['global', 'organization', 'enterprise']):
            raise ValueError("must be one of enum values ('global', 'organization', 'enterprise')")
        return value

    @field_validator('advanced_security')
    def advanced_security_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'code_security', 'secret_protection']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'code_security', 'secret_protection')")
        return value

    @field_validator('dependency_graph')
    def dependency_graph_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependency_graph_autosubmit_action')
    def dependency_graph_autosubmit_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependabot_alerts')
    def dependabot_alerts_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependabot_security_updates')
    def dependabot_security_updates_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('code_scanning_default_setup')
    def code_scanning_default_setup_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('code_scanning_delegated_alert_dismissal')
    def code_scanning_delegated_alert_dismissal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning')
    def secret_scanning_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_push_protection')
    def secret_scanning_push_protection_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_delegated_bypass')
    def secret_scanning_delegated_bypass_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_validity_checks')
    def secret_scanning_validity_checks_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_non_provider_patterns')
    def secret_scanning_non_provider_patterns_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_generic_secrets')
    def secret_scanning_generic_secrets_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_delegated_alert_dismissal')
    def secret_scanning_delegated_alert_dismissal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('private_vulnerability_reporting')
    def private_vulnerability_reporting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('enforcement')
    def enforcement_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enforced', 'unenforced']):
            raise ValueError("must be one of enum values ('enforced', 'unenforced')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeSecurityConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dependency_graph_autosubmit_action_options
        if self.dependency_graph_autosubmit_action_options:
            _dict['dependency_graph_autosubmit_action_options'] = self.dependency_graph_autosubmit_action_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of code_scanning_options
        if self.code_scanning_options:
            _dict['code_scanning_options'] = self.code_scanning_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of code_scanning_default_setup_options
        if self.code_scanning_default_setup_options:
            _dict['code_scanning_default_setup_options'] = self.code_scanning_default_setup_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secret_scanning_delegated_bypass_options
        if self.secret_scanning_delegated_bypass_options:
            _dict['secret_scanning_delegated_bypass_options'] = self.secret_scanning_delegated_bypass_options.to_dict()
        # set to None if code_scanning_options (nullable) is None
        # and model_fields_set contains the field
        if self.code_scanning_options is None and "code_scanning_options" in self.model_fields_set:
            _dict['code_scanning_options'] = None

        # set to None if code_scanning_default_setup_options (nullable) is None
        # and model_fields_set contains the field
        if self.code_scanning_default_setup_options is None and "code_scanning_default_setup_options" in self.model_fields_set:
            _dict['code_scanning_default_setup_options'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeSecurityConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "target_type": obj.get("target_type"),
            "description": obj.get("description"),
            "advanced_security": obj.get("advanced_security"),
            "dependency_graph": obj.get("dependency_graph"),
            "dependency_graph_autosubmit_action": obj.get("dependency_graph_autosubmit_action"),
            "dependency_graph_autosubmit_action_options": CodeSecurityUpdateEnterpriseConfigurationRequestDependencyGraphAutosubmitActionOptions.from_dict(obj["dependency_graph_autosubmit_action_options"]) if obj.get("dependency_graph_autosubmit_action_options") is not None else None,
            "dependabot_alerts": obj.get("dependabot_alerts"),
            "dependabot_security_updates": obj.get("dependabot_security_updates"),
            "code_scanning_options": CodeSecurityConfigurationCodeScanningOptions.from_dict(obj["code_scanning_options"]) if obj.get("code_scanning_options") is not None else None,
            "code_scanning_default_setup": obj.get("code_scanning_default_setup"),
            "code_scanning_default_setup_options": CodeSecurityConfigurationCodeScanningDefaultSetupOptions.from_dict(obj["code_scanning_default_setup_options"]) if obj.get("code_scanning_default_setup_options") is not None else None,
            "code_scanning_delegated_alert_dismissal": obj.get("code_scanning_delegated_alert_dismissal"),
            "secret_scanning": obj.get("secret_scanning"),
            "secret_scanning_push_protection": obj.get("secret_scanning_push_protection"),
            "secret_scanning_delegated_bypass": obj.get("secret_scanning_delegated_bypass"),
            "secret_scanning_delegated_bypass_options": CodeSecurityCreateConfigurationRequestSecretScanningDelegatedBypassOptions.from_dict(obj["secret_scanning_delegated_bypass_options"]) if obj.get("secret_scanning_delegated_bypass_options") is not None else None,
            "secret_scanning_validity_checks": obj.get("secret_scanning_validity_checks"),
            "secret_scanning_non_provider_patterns": obj.get("secret_scanning_non_provider_patterns"),
            "secret_scanning_generic_secrets": obj.get("secret_scanning_generic_secrets"),
            "secret_scanning_delegated_alert_dismissal": obj.get("secret_scanning_delegated_alert_dismissal"),
            "private_vulnerability_reporting": obj.get("private_vulnerability_reporting"),
            "enforcement": obj.get("enforcement"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


