# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.code_scanning_default_setup_options import CodeScanningDefaultSetupOptions
from devopso.clients.github.models.code_security_update_enterprise_configuration_request_dependency_graph_autosubmit_action_options import CodeSecurityUpdateEnterpriseConfigurationRequestDependencyGraphAutosubmitActionOptions
from typing import Optional, Set
from typing_extensions import Self

class CodeSecurityUpdateEnterpriseConfigurationRequest(BaseModel):
    """
    CodeSecurityUpdateEnterpriseConfigurationRequest
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the code security configuration. Must be unique across the enterprise.")
    description: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="A description of the code security configuration")
    advanced_security: Optional[StrictStr] = Field(default=None, description="The enablement status of GitHub Advanced Security features. `enabled` will enable both Code Security and Secret Protection features.  > [!WARNING] > `code_security` and `secret_protection` are deprecated values for this field. Prefer the individual `code_security` and `secret_protection` fields to set the status of these features. ")
    code_security: Optional[StrictStr] = Field(default=None, description="The enablement status of GitHub Code Security features.")
    dependency_graph: Optional[StrictStr] = Field(default=None, description="The enablement status of Dependency Graph")
    dependency_graph_autosubmit_action: Optional[StrictStr] = Field(default=None, description="The enablement status of Automatic dependency submission")
    dependency_graph_autosubmit_action_options: Optional[CodeSecurityUpdateEnterpriseConfigurationRequestDependencyGraphAutosubmitActionOptions] = None
    dependabot_alerts: Optional[StrictStr] = Field(default=None, description="The enablement status of Dependabot alerts")
    dependabot_security_updates: Optional[StrictStr] = Field(default=None, description="The enablement status of Dependabot security updates")
    code_scanning_default_setup: Optional[StrictStr] = Field(default=None, description="The enablement status of code scanning default setup")
    code_scanning_default_setup_options: Optional[CodeScanningDefaultSetupOptions] = None
    code_scanning_delegated_alert_dismissal: Optional[StrictStr] = Field(default='disabled', description="The enablement status of code scanning delegated alert dismissal")
    secret_protection: Optional[StrictStr] = Field(default=None, description="The enablement status of GitHub Secret Protection features.")
    secret_scanning: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning")
    secret_scanning_push_protection: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning push protection")
    secret_scanning_validity_checks: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning validity checks")
    secret_scanning_non_provider_patterns: Optional[StrictStr] = Field(default=None, description="The enablement status of secret scanning non-provider patterns")
    secret_scanning_generic_secrets: Optional[StrictStr] = Field(default='disabled', description="The enablement status of Copilot secret scanning")
    secret_scanning_delegated_alert_dismissal: Optional[StrictStr] = Field(default='disabled', description="The enablement status of secret scanning delegated alert dismissal")
    private_vulnerability_reporting: Optional[StrictStr] = Field(default=None, description="The enablement status of private vulnerability reporting")
    enforcement: Optional[StrictStr] = Field(default=None, description="The enforcement status for a security configuration")
    __properties: ClassVar[List[str]] = ["name", "description", "advanced_security", "code_security", "dependency_graph", "dependency_graph_autosubmit_action", "dependency_graph_autosubmit_action_options", "dependabot_alerts", "dependabot_security_updates", "code_scanning_default_setup", "code_scanning_default_setup_options", "code_scanning_delegated_alert_dismissal", "secret_protection", "secret_scanning", "secret_scanning_push_protection", "secret_scanning_validity_checks", "secret_scanning_non_provider_patterns", "secret_scanning_generic_secrets", "secret_scanning_delegated_alert_dismissal", "private_vulnerability_reporting", "enforcement"]

    @field_validator('advanced_security')
    def advanced_security_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'code_security', 'secret_protection']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'code_security', 'secret_protection')")
        return value

    @field_validator('code_security')
    def code_security_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependency_graph')
    def dependency_graph_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependency_graph_autosubmit_action')
    def dependency_graph_autosubmit_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependabot_alerts')
    def dependabot_alerts_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('dependabot_security_updates')
    def dependabot_security_updates_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('code_scanning_default_setup')
    def code_scanning_default_setup_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('code_scanning_delegated_alert_dismissal')
    def code_scanning_delegated_alert_dismissal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_protection')
    def secret_protection_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning')
    def secret_scanning_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_push_protection')
    def secret_scanning_push_protection_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_validity_checks')
    def secret_scanning_validity_checks_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_non_provider_patterns')
    def secret_scanning_non_provider_patterns_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_generic_secrets')
    def secret_scanning_generic_secrets_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('secret_scanning_delegated_alert_dismissal')
    def secret_scanning_delegated_alert_dismissal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('private_vulnerability_reporting')
    def private_vulnerability_reporting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'not_set']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'not_set')")
        return value

    @field_validator('enforcement')
    def enforcement_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enforced', 'unenforced']):
            raise ValueError("must be one of enum values ('enforced', 'unenforced')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeSecurityUpdateEnterpriseConfigurationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dependency_graph_autosubmit_action_options
        if self.dependency_graph_autosubmit_action_options:
            _dict['dependency_graph_autosubmit_action_options'] = self.dependency_graph_autosubmit_action_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of code_scanning_default_setup_options
        if self.code_scanning_default_setup_options:
            _dict['code_scanning_default_setup_options'] = self.code_scanning_default_setup_options.to_dict()
        # set to None if code_scanning_default_setup_options (nullable) is None
        # and model_fields_set contains the field
        if self.code_scanning_default_setup_options is None and "code_scanning_default_setup_options" in self.model_fields_set:
            _dict['code_scanning_default_setup_options'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeSecurityUpdateEnterpriseConfigurationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "advanced_security": obj.get("advanced_security"),
            "code_security": obj.get("code_security"),
            "dependency_graph": obj.get("dependency_graph"),
            "dependency_graph_autosubmit_action": obj.get("dependency_graph_autosubmit_action"),
            "dependency_graph_autosubmit_action_options": CodeSecurityUpdateEnterpriseConfigurationRequestDependencyGraphAutosubmitActionOptions.from_dict(obj["dependency_graph_autosubmit_action_options"]) if obj.get("dependency_graph_autosubmit_action_options") is not None else None,
            "dependabot_alerts": obj.get("dependabot_alerts"),
            "dependabot_security_updates": obj.get("dependabot_security_updates"),
            "code_scanning_default_setup": obj.get("code_scanning_default_setup"),
            "code_scanning_default_setup_options": CodeScanningDefaultSetupOptions.from_dict(obj["code_scanning_default_setup_options"]) if obj.get("code_scanning_default_setup_options") is not None else None,
            "code_scanning_delegated_alert_dismissal": obj.get("code_scanning_delegated_alert_dismissal") if obj.get("code_scanning_delegated_alert_dismissal") is not None else 'disabled',
            "secret_protection": obj.get("secret_protection"),
            "secret_scanning": obj.get("secret_scanning"),
            "secret_scanning_push_protection": obj.get("secret_scanning_push_protection"),
            "secret_scanning_validity_checks": obj.get("secret_scanning_validity_checks"),
            "secret_scanning_non_provider_patterns": obj.get("secret_scanning_non_provider_patterns"),
            "secret_scanning_generic_secrets": obj.get("secret_scanning_generic_secrets") if obj.get("secret_scanning_generic_secrets") is not None else 'disabled',
            "secret_scanning_delegated_alert_dismissal": obj.get("secret_scanning_delegated_alert_dismissal") if obj.get("secret_scanning_delegated_alert_dismissal") is not None else 'disabled',
            "private_vulnerability_reporting": obj.get("private_vulnerability_reporting"),
            "enforcement": obj.get("enforcement")
        })
        return _obj


