# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.codespace_git_status import CodespaceGitStatus
from devopso.clients.github.models.codespace_runtime_constraints import CodespaceRuntimeConstraints
from devopso.clients.github.models.minimal_repository import MinimalRepository
from devopso.clients.github.models.nullable_codespace_machine import NullableCodespaceMachine
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class Codespace(BaseModel):
    """
    A codespace.
    """ # noqa: E501
    id: StrictInt
    name: StrictStr = Field(description="Automatically generated name of this codespace.")
    display_name: Optional[StrictStr] = Field(default=None, description="Display name for this codespace.")
    environment_id: Optional[StrictStr] = Field(description="UUID identifying this codespace's environment.")
    owner: SimpleUser
    billable_owner: SimpleUser
    repository: MinimalRepository
    machine: Optional[NullableCodespaceMachine]
    devcontainer_path: Optional[StrictStr] = Field(default=None, description="Path to devcontainer.json from repo root used to create Codespace.")
    prebuild: Optional[StrictBool] = Field(description="Whether the codespace was created from a prebuild.")
    created_at: datetime
    updated_at: datetime
    last_used_at: datetime = Field(description="Last known time this codespace was started.")
    state: StrictStr = Field(description="State of this codespace.")
    url: StrictStr = Field(description="API URL for this codespace.")
    git_status: CodespaceGitStatus
    location: StrictStr = Field(description="The initally assigned location of a new codespace.")
    idle_timeout_minutes: Optional[StrictInt] = Field(description="The number of minutes of inactivity after which this codespace will be automatically stopped.")
    web_url: StrictStr = Field(description="URL to access this codespace on the web.")
    machines_url: StrictStr = Field(description="API URL to access available alternate machine types for this codespace.")
    start_url: StrictStr = Field(description="API URL to start this codespace.")
    stop_url: StrictStr = Field(description="API URL to stop this codespace.")
    publish_url: Optional[StrictStr] = Field(default=None, description="API URL to publish this codespace to a new repository.")
    pulls_url: Optional[StrictStr] = Field(description="API URL for the Pull Request associated with this codespace, if any.")
    recent_folders: List[StrictStr]
    runtime_constraints: Optional[CodespaceRuntimeConstraints] = None
    pending_operation: Optional[StrictBool] = Field(default=None, description="Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.")
    pending_operation_disabled_reason: Optional[StrictStr] = Field(default=None, description="Text to show user when codespace is disabled by a pending operation")
    idle_timeout_notice: Optional[StrictStr] = Field(default=None, description="Text to show user when codespace idle timeout minutes has been overriden by an organization policy")
    retention_period_minutes: Optional[StrictInt] = Field(default=None, description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).")
    retention_expires_at: Optional[datetime] = Field(default=None, description="When a codespace will be auto-deleted based on the \"retention_period_minutes\" and \"last_used_at\"")
    last_known_stop_notice: Optional[StrictStr] = Field(default=None, description="The text to display to a user when a codespace has been stopped for a potentially actionable reason.")
    __properties: ClassVar[List[str]] = ["id", "name", "display_name", "environment_id", "owner", "billable_owner", "repository", "machine", "devcontainer_path", "prebuild", "created_at", "updated_at", "last_used_at", "state", "url", "git_status", "location", "idle_timeout_minutes", "web_url", "machines_url", "start_url", "stop_url", "publish_url", "pulls_url", "recent_folders", "runtime_constraints", "pending_operation", "pending_operation_disabled_reason", "idle_timeout_notice", "retention_period_minutes", "retention_expires_at", "last_known_stop_notice"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Unknown', 'Created', 'Queued', 'Provisioning', 'Available', 'Awaiting', 'Unavailable', 'Deleted', 'Moved', 'Shutdown', 'Archived', 'Starting', 'ShuttingDown', 'Failed', 'Exporting', 'Updating', 'Rebuilding']):
            raise ValueError("must be one of enum values ('Unknown', 'Created', 'Queued', 'Provisioning', 'Available', 'Awaiting', 'Unavailable', 'Deleted', 'Moved', 'Shutdown', 'Archived', 'Starting', 'ShuttingDown', 'Failed', 'Exporting', 'Updating', 'Rebuilding')")
        return value

    @field_validator('location')
    def location_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['EastUs', 'SouthEastAsia', 'WestEurope', 'WestUs2']):
            raise ValueError("must be one of enum values ('EastUs', 'SouthEastAsia', 'WestEurope', 'WestUs2')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Codespace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billable_owner
        if self.billable_owner:
            _dict['billable_owner'] = self.billable_owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine
        if self.machine:
            _dict['machine'] = self.machine.to_dict()
        # override the default output from pydantic by calling `to_dict()` of git_status
        if self.git_status:
            _dict['git_status'] = self.git_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of runtime_constraints
        if self.runtime_constraints:
            _dict['runtime_constraints'] = self.runtime_constraints.to_dict()
        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if environment_id (nullable) is None
        # and model_fields_set contains the field
        if self.environment_id is None and "environment_id" in self.model_fields_set:
            _dict['environment_id'] = None

        # set to None if machine (nullable) is None
        # and model_fields_set contains the field
        if self.machine is None and "machine" in self.model_fields_set:
            _dict['machine'] = None

        # set to None if devcontainer_path (nullable) is None
        # and model_fields_set contains the field
        if self.devcontainer_path is None and "devcontainer_path" in self.model_fields_set:
            _dict['devcontainer_path'] = None

        # set to None if prebuild (nullable) is None
        # and model_fields_set contains the field
        if self.prebuild is None and "prebuild" in self.model_fields_set:
            _dict['prebuild'] = None

        # set to None if idle_timeout_minutes (nullable) is None
        # and model_fields_set contains the field
        if self.idle_timeout_minutes is None and "idle_timeout_minutes" in self.model_fields_set:
            _dict['idle_timeout_minutes'] = None

        # set to None if publish_url (nullable) is None
        # and model_fields_set contains the field
        if self.publish_url is None and "publish_url" in self.model_fields_set:
            _dict['publish_url'] = None

        # set to None if pulls_url (nullable) is None
        # and model_fields_set contains the field
        if self.pulls_url is None and "pulls_url" in self.model_fields_set:
            _dict['pulls_url'] = None

        # set to None if pending_operation (nullable) is None
        # and model_fields_set contains the field
        if self.pending_operation is None and "pending_operation" in self.model_fields_set:
            _dict['pending_operation'] = None

        # set to None if pending_operation_disabled_reason (nullable) is None
        # and model_fields_set contains the field
        if self.pending_operation_disabled_reason is None and "pending_operation_disabled_reason" in self.model_fields_set:
            _dict['pending_operation_disabled_reason'] = None

        # set to None if idle_timeout_notice (nullable) is None
        # and model_fields_set contains the field
        if self.idle_timeout_notice is None and "idle_timeout_notice" in self.model_fields_set:
            _dict['idle_timeout_notice'] = None

        # set to None if retention_period_minutes (nullable) is None
        # and model_fields_set contains the field
        if self.retention_period_minutes is None and "retention_period_minutes" in self.model_fields_set:
            _dict['retention_period_minutes'] = None

        # set to None if retention_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.retention_expires_at is None and "retention_expires_at" in self.model_fields_set:
            _dict['retention_expires_at'] = None

        # set to None if last_known_stop_notice (nullable) is None
        # and model_fields_set contains the field
        if self.last_known_stop_notice is None and "last_known_stop_notice" in self.model_fields_set:
            _dict['last_known_stop_notice'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Codespace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "environment_id": obj.get("environment_id"),
            "owner": SimpleUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "billable_owner": SimpleUser.from_dict(obj["billable_owner"]) if obj.get("billable_owner") is not None else None,
            "repository": MinimalRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "machine": NullableCodespaceMachine.from_dict(obj["machine"]) if obj.get("machine") is not None else None,
            "devcontainer_path": obj.get("devcontainer_path"),
            "prebuild": obj.get("prebuild"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "last_used_at": obj.get("last_used_at"),
            "state": obj.get("state"),
            "url": obj.get("url"),
            "git_status": CodespaceGitStatus.from_dict(obj["git_status"]) if obj.get("git_status") is not None else None,
            "location": obj.get("location"),
            "idle_timeout_minutes": obj.get("idle_timeout_minutes"),
            "web_url": obj.get("web_url"),
            "machines_url": obj.get("machines_url"),
            "start_url": obj.get("start_url"),
            "stop_url": obj.get("stop_url"),
            "publish_url": obj.get("publish_url"),
            "pulls_url": obj.get("pulls_url"),
            "recent_folders": obj.get("recent_folders"),
            "runtime_constraints": CodespaceRuntimeConstraints.from_dict(obj["runtime_constraints"]) if obj.get("runtime_constraints") is not None else None,
            "pending_operation": obj.get("pending_operation"),
            "pending_operation_disabled_reason": obj.get("pending_operation_disabled_reason"),
            "idle_timeout_notice": obj.get("idle_timeout_notice"),
            "retention_period_minutes": obj.get("retention_period_minutes"),
            "retention_expires_at": obj.get("retention_expires_at"),
            "last_known_stop_notice": obj.get("last_known_stop_notice")
        })
        return _obj


