# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CodespaceExportDetails(BaseModel):
    """
    An export of a codespace. Also, latest export details for a codespace can be fetched with id = latest
    """ # noqa: E501
    state: Optional[StrictStr] = Field(default=None, description="State of the latest export")
    completed_at: Optional[datetime] = Field(default=None, description="Completion time of the last export operation")
    branch: Optional[StrictStr] = Field(default=None, description="Name of the exported branch")
    sha: Optional[StrictStr] = Field(default=None, description="Git commit SHA of the exported branch")
    id: Optional[StrictStr] = Field(default=None, description="Id for the export details")
    export_url: Optional[StrictStr] = Field(default=None, description="Url for fetching export details")
    html_url: Optional[StrictStr] = Field(default=None, description="Web url for the exported branch")
    __properties: ClassVar[List[str]] = ["state", "completed_at", "branch", "sha", "id", "export_url", "html_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodespaceExportDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completed_at'] = None

        # set to None if branch (nullable) is None
        # and model_fields_set contains the field
        if self.branch is None and "branch" in self.model_fields_set:
            _dict['branch'] = None

        # set to None if sha (nullable) is None
        # and model_fields_set contains the field
        if self.sha is None and "sha" in self.model_fields_set:
            _dict['sha'] = None

        # set to None if html_url (nullable) is None
        # and model_fields_set contains the field
        if self.html_url is None and "html_url" in self.model_fields_set:
            _dict['html_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodespaceExportDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "completed_at": obj.get("completed_at"),
            "branch": obj.get("branch"),
            "sha": obj.get("sha"),
            "id": obj.get("id"),
            "export_url": obj.get("export_url"),
            "html_url": obj.get("html_url")
        })
        return _obj


