# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CodespaceMachine(BaseModel):
    """
    A description of the machine powering a codespace.
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the machine.")
    display_name: StrictStr = Field(description="The display name of the machine includes cores, memory, and storage.")
    operating_system: StrictStr = Field(description="The operating system of the machine.")
    storage_in_bytes: StrictInt = Field(description="How much storage is available to the codespace.")
    memory_in_bytes: StrictInt = Field(description="How much memory is available to the codespace.")
    cpus: StrictInt = Field(description="How many cores are available to the codespace.")
    prebuild_availability: Optional[StrictStr] = Field(description="Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be \"null\" if prebuilds are not supported or prebuild availability could not be determined. Value will be \"none\" if no prebuild is available. Latest values \"ready\" and \"in_progress\" indicate the prebuild availability status.")
    __properties: ClassVar[List[str]] = ["name", "display_name", "operating_system", "storage_in_bytes", "memory_in_bytes", "cpus", "prebuild_availability"]

    @field_validator('prebuild_availability')
    def prebuild_availability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['none', 'ready', 'in_progress']):
            raise ValueError("must be one of enum values ('none', 'ready', 'in_progress')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodespaceMachine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if prebuild_availability (nullable) is None
        # and model_fields_set contains the field
        if self.prebuild_availability is None and "prebuild_availability" in self.model_fields_set:
            _dict['prebuild_availability'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodespaceMachine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "operating_system": obj.get("operating_system"),
            "storage_in_bytes": obj.get("storage_in_bytes"),
            "memory_in_bytes": obj.get("memory_in_bytes"),
            "cpus": obj.get("cpus"),
            "prebuild_availability": obj.get("prebuild_availability")
        })
        return _obj


