# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.committer import Committer
from typing import Optional, Set
from typing_extensions import Self

class Commit(BaseModel):
    """
    Commit
    """ # noqa: E501
    added: Optional[List[StrictStr]] = Field(default=None, description="An array of files added in the commit. A maximum of 3000 changed files will be reported per commit.")
    author: Committer
    committer: Committer
    distinct: StrictBool = Field(description="Whether this commit is distinct from any that have been pushed before.")
    id: StrictStr
    message: StrictStr = Field(description="The commit message.")
    modified: Optional[List[StrictStr]] = Field(default=None, description="An array of files modified by the commit. A maximum of 3000 changed files will be reported per commit.")
    removed: Optional[List[StrictStr]] = Field(default=None, description="An array of files removed in the commit. A maximum of 3000 changed files will be reported per commit.")
    timestamp: datetime = Field(description="The ISO 8601 timestamp of the commit.")
    tree_id: StrictStr
    url: StrictStr = Field(description="URL that points to the commit API resource.")
    __properties: ClassVar[List[str]] = ["added", "author", "committer", "distinct", "id", "message", "modified", "removed", "timestamp", "tree_id", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Commit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of committer
        if self.committer:
            _dict['committer'] = self.committer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Commit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "added": obj.get("added"),
            "author": Committer.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "committer": Committer.from_dict(obj["committer"]) if obj.get("committer") is not None else None,
            "distinct": obj.get("distinct"),
            "id": obj.get("id"),
            "message": obj.get("message"),
            "modified": obj.get("modified"),
            "removed": obj.get("removed"),
            "timestamp": obj.get("timestamp"),
            "tree_id": obj.get("tree_id"),
            "url": obj.get("url")
        })
        return _obj


