# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.commit import Commit
from devopso.clients.github.models.diff_entry import DiffEntry
from typing import Optional, Set
from typing_extensions import Self

class CommitComparison(BaseModel):
    """
    Commit Comparison
    """ # noqa: E501
    url: StrictStr
    html_url: StrictStr
    permalink_url: StrictStr
    diff_url: StrictStr
    patch_url: StrictStr
    base_commit: Commit
    merge_base_commit: Commit
    status: StrictStr
    ahead_by: StrictInt
    behind_by: StrictInt
    total_commits: StrictInt
    commits: List[Commit]
    files: Optional[List[DiffEntry]] = None
    __properties: ClassVar[List[str]] = ["url", "html_url", "permalink_url", "diff_url", "patch_url", "base_commit", "merge_base_commit", "status", "ahead_by", "behind_by", "total_commits", "commits", "files"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['diverged', 'ahead', 'behind', 'identical']):
            raise ValueError("must be one of enum values ('diverged', 'ahead', 'behind', 'identical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommitComparison from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of base_commit
        if self.base_commit:
            _dict['base_commit'] = self.base_commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of merge_base_commit
        if self.merge_base_commit:
            _dict['merge_base_commit'] = self.merge_base_commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item_commits in self.commits:
                if _item_commits:
                    _items.append(_item_commits.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommitComparison from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "permalink_url": obj.get("permalink_url"),
            "diff_url": obj.get("diff_url"),
            "patch_url": obj.get("patch_url"),
            "base_commit": Commit.from_dict(obj["base_commit"]) if obj.get("base_commit") is not None else None,
            "merge_base_commit": Commit.from_dict(obj["merge_base_commit"]) if obj.get("merge_base_commit") is not None else None,
            "status": obj.get("status"),
            "ahead_by": obj.get("ahead_by"),
            "behind_by": obj.get("behind_by"),
            "total_commits": obj.get("total_commits"),
            "commits": [Commit.from_dict(_item) for _item in obj["commits"]] if obj.get("commits") is not None else None,
            "files": [DiffEntry.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None
        })
        return _obj


