# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.commit_search_result_item_commit import CommitSearchResultItemCommit
from devopso.clients.github.models.file_commit_commit_parents_inner import FileCommitCommitParentsInner
from devopso.clients.github.models.minimal_repository import MinimalRepository
from devopso.clients.github.models.nullable_git_user import NullableGitUser
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.search_result_text_matches_inner import SearchResultTextMatchesInner
from typing import Optional, Set
from typing_extensions import Self

class CommitSearchResultItem(BaseModel):
    """
    Commit Search Result Item
    """ # noqa: E501
    url: StrictStr
    sha: StrictStr
    html_url: StrictStr
    comments_url: StrictStr
    commit: CommitSearchResultItemCommit
    author: Optional[NullableSimpleUser]
    committer: Optional[NullableGitUser]
    parents: List[FileCommitCommitParentsInner]
    repository: MinimalRepository
    score: Union[StrictFloat, StrictInt]
    node_id: StrictStr
    text_matches: Optional[List[SearchResultTextMatchesInner]] = None
    __properties: ClassVar[List[str]] = ["url", "sha", "html_url", "comments_url", "commit", "author", "committer", "parents", "repository", "score", "node_id", "text_matches"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommitSearchResultItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of commit
        if self.commit:
            _dict['commit'] = self.commit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of committer
        if self.committer:
            _dict['committer'] = self.committer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parents (list)
        _items = []
        if self.parents:
            for _item_parents in self.parents:
                if _item_parents:
                    _items.append(_item_parents.to_dict())
            _dict['parents'] = _items
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in text_matches (list)
        _items = []
        if self.text_matches:
            for _item_text_matches in self.text_matches:
                if _item_text_matches:
                    _items.append(_item_text_matches.to_dict())
            _dict['text_matches'] = _items
        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if committer (nullable) is None
        # and model_fields_set contains the field
        if self.committer is None and "committer" in self.model_fields_set:
            _dict['committer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommitSearchResultItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "sha": obj.get("sha"),
            "html_url": obj.get("html_url"),
            "comments_url": obj.get("comments_url"),
            "commit": CommitSearchResultItemCommit.from_dict(obj["commit"]) if obj.get("commit") is not None else None,
            "author": NullableSimpleUser.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "committer": NullableGitUser.from_dict(obj["committer"]) if obj.get("committer") is not None else None,
            "parents": [FileCommitCommitParentsInner.from_dict(_item) for _item in obj["parents"]] if obj.get("parents") is not None else None,
            "repository": MinimalRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "score": obj.get("score"),
            "node_id": obj.get("node_id"),
            "text_matches": [SearchResultTextMatchesInner.from_dict(_item) for _item in obj["text_matches"]] if obj.get("text_matches") is not None else None
        })
        return _obj


