# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CopilotIdeChatEditorsInnerModelsInner(BaseModel):
    """
    CopilotIdeChatEditorsInnerModelsInner
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the model used for Copilot Chat. If the default model is used will appear as 'default'.")
    is_custom_model: Optional[StrictBool] = Field(default=None, description="Indicates whether a model is custom or default.")
    custom_model_training_date: Optional[StrictStr] = Field(default=None, description="The training date for the custom model.")
    total_engaged_users: Optional[StrictInt] = Field(default=None, description="The number of users who prompted Copilot Chat in the given editor and model.")
    total_chats: Optional[StrictInt] = Field(default=None, description="The total number of chats initiated by users in the given editor and model.")
    total_chat_insertion_events: Optional[StrictInt] = Field(default=None, description="The number of times users accepted a code suggestion from Copilot Chat using the 'Insert Code' UI element, for the given editor.")
    total_chat_copy_events: Optional[StrictInt] = Field(default=None, description="The number of times users copied a code suggestion from Copilot Chat using the keyboard, or the 'Copy' UI element, for the given editor.")
    __properties: ClassVar[List[str]] = ["name", "is_custom_model", "custom_model_training_date", "total_engaged_users", "total_chats", "total_chat_insertion_events", "total_chat_copy_events"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotIdeChatEditorsInnerModelsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if custom_model_training_date (nullable) is None
        # and model_fields_set contains the field
        if self.custom_model_training_date is None and "custom_model_training_date" in self.model_fields_set:
            _dict['custom_model_training_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotIdeChatEditorsInnerModelsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "is_custom_model": obj.get("is_custom_model"),
            "custom_model_training_date": obj.get("custom_model_training_date"),
            "total_engaged_users": obj.get("total_engaged_users"),
            "total_chats": obj.get("total_chats"),
            "total_chat_insertion_events": obj.get("total_chat_insertion_events"),
            "total_chat_copy_events": obj.get("total_chat_copy_events")
        })
        return _obj


