# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.copilot_ide_code_completions_editors_inner import CopilotIdeCodeCompletionsEditorsInner
from devopso.clients.github.models.copilot_ide_code_completions_languages_inner import CopilotIdeCodeCompletionsLanguagesInner
from typing import Optional, Set
from typing_extensions import Self

class CopilotIdeCodeCompletions(BaseModel):
    """
    Usage metrics for Copilot editor code completions in the IDE.
    """ # noqa: E501
    total_engaged_users: Optional[StrictInt] = Field(default=None, description="Number of users who accepted at least one Copilot code suggestion, across all active editors. Includes both full and partial acceptances.")
    languages: Optional[List[CopilotIdeCodeCompletionsLanguagesInner]] = Field(default=None, description="Code completion metrics for active languages.")
    editors: Optional[List[CopilotIdeCodeCompletionsEditorsInner]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["total_engaged_users", "languages", "editors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotIdeCodeCompletions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in languages (list)
        _items = []
        if self.languages:
            for _item_languages in self.languages:
                if _item_languages:
                    _items.append(_item_languages.to_dict())
            _dict['languages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in editors (list)
        _items = []
        if self.editors:
            for _item_editors in self.editors:
                if _item_editors:
                    _items.append(_item_editors.to_dict())
            _dict['editors'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotIdeCodeCompletions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total_engaged_users": obj.get("total_engaged_users"),
            "languages": [CopilotIdeCodeCompletionsLanguagesInner.from_dict(_item) for _item in obj["languages"]] if obj.get("languages") is not None else None,
            "editors": [CopilotIdeCodeCompletionsEditorsInner.from_dict(_item) for _item in obj["editors"]] if obj.get("editors") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


