# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.copilot_ide_code_completions_editors_inner_models_inner_languages_inner import CopilotIdeCodeCompletionsEditorsInnerModelsInnerLanguagesInner
from typing import Optional, Set
from typing_extensions import Self

class CopilotIdeCodeCompletionsEditorsInnerModelsInner(BaseModel):
    """
    CopilotIdeCodeCompletionsEditorsInnerModelsInner
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the model used for Copilot code completion suggestions. If the default model is used will appear as 'default'.")
    is_custom_model: Optional[StrictBool] = Field(default=None, description="Indicates whether a model is custom or default.")
    custom_model_training_date: Optional[StrictStr] = Field(default=None, description="The training date for the custom model.")
    total_engaged_users: Optional[StrictInt] = Field(default=None, description="Number of users who accepted at least one Copilot code completion suggestion for the given editor, for the given language and model. Includes both full and partial acceptances.")
    languages: Optional[List[CopilotIdeCodeCompletionsEditorsInnerModelsInnerLanguagesInner]] = Field(default=None, description="Code completion metrics for active languages, for the given editor.")
    __properties: ClassVar[List[str]] = ["name", "is_custom_model", "custom_model_training_date", "total_engaged_users", "languages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotIdeCodeCompletionsEditorsInnerModelsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in languages (list)
        _items = []
        if self.languages:
            for _item_languages in self.languages:
                if _item_languages:
                    _items.append(_item_languages.to_dict())
            _dict['languages'] = _items
        # set to None if custom_model_training_date (nullable) is None
        # and model_fields_set contains the field
        if self.custom_model_training_date is None and "custom_model_training_date" in self.model_fields_set:
            _dict['custom_model_training_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotIdeCodeCompletionsEditorsInnerModelsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "is_custom_model": obj.get("is_custom_model"),
            "custom_model_training_date": obj.get("custom_model_training_date"),
            "total_engaged_users": obj.get("total_engaged_users"),
            "languages": [CopilotIdeCodeCompletionsEditorsInnerModelsInnerLanguagesInner.from_dict(_item) for _item in obj["languages"]] if obj.get("languages") is not None else None
        })
        return _obj


