# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.copilot_organization_seat_breakdown import CopilotOrganizationSeatBreakdown
from typing import Optional, Set
from typing_extensions import Self

class CopilotOrganizationDetails(BaseModel):
    """
    Information about the seat breakdown and policies set for an organization with a Copilot Business or Copilot Enterprise subscription.
    """ # noqa: E501
    seat_breakdown: CopilotOrganizationSeatBreakdown
    public_code_suggestions: StrictStr = Field(description="The organization policy for allowing or blocking suggestions matching public code (duplication detection filter).")
    ide_chat: Optional[StrictStr] = Field(default=None, description="The organization policy for allowing or disallowing Copilot Chat in the IDE.")
    platform_chat: Optional[StrictStr] = Field(default=None, description="The organization policy for allowing or disallowing Copilot features on GitHub.com.")
    cli: Optional[StrictStr] = Field(default=None, description="The organization policy for allowing or disallowing Copilot in the CLI.")
    seat_management_setting: StrictStr = Field(description="The mode of assigning new seats.")
    plan_type: Optional[StrictStr] = Field(default=None, description="The Copilot plan of the organization, or the parent enterprise, when applicable.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["seat_breakdown", "public_code_suggestions", "ide_chat", "platform_chat", "cli", "seat_management_setting", "plan_type"]

    @field_validator('public_code_suggestions')
    def public_code_suggestions_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['allow', 'block', 'unconfigured']):
            raise ValueError("must be one of enum values ('allow', 'block', 'unconfigured')")
        return value

    @field_validator('ide_chat')
    def ide_chat_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'unconfigured']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'unconfigured')")
        return value

    @field_validator('platform_chat')
    def platform_chat_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'unconfigured']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'unconfigured')")
        return value

    @field_validator('cli')
    def cli_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['enabled', 'disabled', 'unconfigured']):
            raise ValueError("must be one of enum values ('enabled', 'disabled', 'unconfigured')")
        return value

    @field_validator('seat_management_setting')
    def seat_management_setting_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['assign_all', 'assign_selected', 'disabled', 'unconfigured']):
            raise ValueError("must be one of enum values ('assign_all', 'assign_selected', 'disabled', 'unconfigured')")
        return value

    @field_validator('plan_type')
    def plan_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['business', 'enterprise']):
            raise ValueError("must be one of enum values ('business', 'enterprise')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotOrganizationDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of seat_breakdown
        if self.seat_breakdown:
            _dict['seat_breakdown'] = self.seat_breakdown.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotOrganizationDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "seat_breakdown": CopilotOrganizationSeatBreakdown.from_dict(obj["seat_breakdown"]) if obj.get("seat_breakdown") is not None else None,
            "public_code_suggestions": obj.get("public_code_suggestions"),
            "ide_chat": obj.get("ide_chat"),
            "platform_chat": obj.get("platform_chat"),
            "cli": obj.get("cli"),
            "seat_management_setting": obj.get("seat_management_setting"),
            "plan_type": obj.get("plan_type")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


