# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CopilotOrganizationSeatBreakdown(BaseModel):
    """
    The breakdown of Copilot Business seats for the organization.
    """ # noqa: E501
    total: Optional[StrictInt] = Field(default=None, description="The total number of seats being billed for the organization as of the current billing cycle.")
    added_this_cycle: Optional[StrictInt] = Field(default=None, description="Seats added during the current billing cycle.")
    pending_cancellation: Optional[StrictInt] = Field(default=None, description="The number of seats that are pending cancellation at the end of the current billing cycle.")
    pending_invitation: Optional[StrictInt] = Field(default=None, description="The number of users who have been invited to receive a Copilot seat through this organization.")
    active_this_cycle: Optional[StrictInt] = Field(default=None, description="The number of seats that have used Copilot during the current billing cycle.")
    inactive_this_cycle: Optional[StrictInt] = Field(default=None, description="The number of seats that have not used Copilot during the current billing cycle.")
    __properties: ClassVar[List[str]] = ["total", "added_this_cycle", "pending_cancellation", "pending_invitation", "active_this_cycle", "inactive_this_cycle"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotOrganizationSeatBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotOrganizationSeatBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total": obj.get("total"),
            "added_this_cycle": obj.get("added_this_cycle"),
            "pending_cancellation": obj.get("pending_cancellation"),
            "pending_invitation": obj.get("pending_invitation"),
            "active_this_cycle": obj.get("active_this_cycle"),
            "inactive_this_cycle": obj.get("inactive_this_cycle")
        })
        return _obj


