# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.copilot_seat_details_assigning_team import CopilotSeatDetailsAssigningTeam
from devopso.clients.github.models.nullable_organization_simple import NullableOrganizationSimple
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from typing import Optional, Set
from typing_extensions import Self

class CopilotSeatDetails(BaseModel):
    """
    Information about a Copilot Business seat assignment for a user, team, or organization.
    """ # noqa: E501
    assignee: Optional[NullableSimpleUser] = None
    organization: Optional[NullableOrganizationSimple] = None
    assigning_team: Optional[CopilotSeatDetailsAssigningTeam] = None
    pending_cancellation_date: Optional[date] = Field(default=None, description="The pending cancellation date for the seat, in `YYYY-MM-DD` format. This will be null unless the assignee's Copilot access has been canceled during the current billing cycle. If the seat has been cancelled, this corresponds to the start of the organization's next billing cycle.")
    last_activity_at: Optional[datetime] = Field(default=None, description="Timestamp of user's last GitHub Copilot activity, in ISO 8601 format.")
    last_activity_editor: Optional[StrictStr] = Field(default=None, description="Last editor that was used by the user for a GitHub Copilot completion.")
    last_authenticated_at: Optional[datetime] = Field(default=None, description="Timestamp of the last time the user authenticated with GitHub Copilot, in ISO 8601 format.")
    created_at: datetime = Field(description="Timestamp of when the assignee was last granted access to GitHub Copilot, in ISO 8601 format.")
    updated_at: Optional[datetime] = Field(default=None, description="**Closing down notice:** This field is no longer relevant and is closing down. Use the `created_at` field to determine when the assignee was last granted access to GitHub Copilot. Timestamp of when the assignee's GitHub Copilot access was last updated, in ISO 8601 format.")
    plan_type: Optional[StrictStr] = Field(default=None, description="The Copilot plan of the organization, or the parent enterprise, when applicable.")
    __properties: ClassVar[List[str]] = ["assignee", "organization", "assigning_team", "pending_cancellation_date", "last_activity_at", "last_activity_editor", "last_authenticated_at", "created_at", "updated_at", "plan_type"]

    @field_validator('plan_type')
    def plan_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['business', 'enterprise', 'unknown']):
            raise ValueError("must be one of enum values ('business', 'enterprise', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotSeatDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of assignee
        if self.assignee:
            _dict['assignee'] = self.assignee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assigning_team
        if self.assigning_team:
            _dict['assigning_team'] = self.assigning_team.to_dict()
        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if organization (nullable) is None
        # and model_fields_set contains the field
        if self.organization is None and "organization" in self.model_fields_set:
            _dict['organization'] = None

        # set to None if assigning_team (nullable) is None
        # and model_fields_set contains the field
        if self.assigning_team is None and "assigning_team" in self.model_fields_set:
            _dict['assigning_team'] = None

        # set to None if pending_cancellation_date (nullable) is None
        # and model_fields_set contains the field
        if self.pending_cancellation_date is None and "pending_cancellation_date" in self.model_fields_set:
            _dict['pending_cancellation_date'] = None

        # set to None if last_activity_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_activity_at is None and "last_activity_at" in self.model_fields_set:
            _dict['last_activity_at'] = None

        # set to None if last_activity_editor (nullable) is None
        # and model_fields_set contains the field
        if self.last_activity_editor is None and "last_activity_editor" in self.model_fields_set:
            _dict['last_activity_editor'] = None

        # set to None if last_authenticated_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_authenticated_at is None and "last_authenticated_at" in self.model_fields_set:
            _dict['last_authenticated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotSeatDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignee": NullableSimpleUser.from_dict(obj["assignee"]) if obj.get("assignee") is not None else None,
            "organization": NullableOrganizationSimple.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "assigning_team": CopilotSeatDetailsAssigningTeam.from_dict(obj["assigning_team"]) if obj.get("assigning_team") is not None else None,
            "pending_cancellation_date": obj.get("pending_cancellation_date"),
            "last_activity_at": obj.get("last_activity_at"),
            "last_activity_editor": obj.get("last_activity_editor"),
            "last_authenticated_at": obj.get("last_authenticated_at"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "plan_type": obj.get("plan_type")
        })
        return _obj


