# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.copilot_dotcom_chat import CopilotDotcomChat
from devopso.clients.github.models.copilot_dotcom_pull_requests import CopilotDotcomPullRequests
from devopso.clients.github.models.copilot_ide_chat import CopilotIdeChat
from devopso.clients.github.models.copilot_ide_code_completions import CopilotIdeCodeCompletions
from typing import Optional, Set
from typing_extensions import Self

class CopilotUsageMetricsDay(BaseModel):
    """
    Copilot usage metrics for a given day.
    """ # noqa: E501
    var_date: date = Field(description="The date for which the usage metrics are aggregated, in `YYYY-MM-DD` format.", alias="date")
    total_active_users: Optional[StrictInt] = Field(default=None, description="The total number of Copilot users with activity belonging to any Copilot feature, globally, for the given day. Includes passive activity such as receiving a code suggestion, as well as engagement activity such as accepting a code suggestion or prompting chat. Does not include authentication events. Is not limited to the individual features detailed on the endpoint.")
    total_engaged_users: Optional[StrictInt] = Field(default=None, description="The total number of Copilot users who engaged with any Copilot feature, for the given day. Examples include but are not limited to accepting a code suggestion, prompting Copilot chat, or triggering a PR Summary. Does not include authentication events. Is not limited to the individual features detailed on the endpoint.")
    copilot_ide_code_completions: Optional[CopilotIdeCodeCompletions] = None
    copilot_ide_chat: Optional[CopilotIdeChat] = None
    copilot_dotcom_chat: Optional[CopilotDotcomChat] = None
    copilot_dotcom_pull_requests: Optional[CopilotDotcomPullRequests] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["date", "total_active_users", "total_engaged_users", "copilot_ide_code_completions", "copilot_ide_chat", "copilot_dotcom_chat", "copilot_dotcom_pull_requests"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CopilotUsageMetricsDay from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of copilot_ide_code_completions
        if self.copilot_ide_code_completions:
            _dict['copilot_ide_code_completions'] = self.copilot_ide_code_completions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of copilot_ide_chat
        if self.copilot_ide_chat:
            _dict['copilot_ide_chat'] = self.copilot_ide_chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of copilot_dotcom_chat
        if self.copilot_dotcom_chat:
            _dict['copilot_dotcom_chat'] = self.copilot_dotcom_chat.to_dict()
        # override the default output from pydantic by calling `to_dict()` of copilot_dotcom_pull_requests
        if self.copilot_dotcom_pull_requests:
            _dict['copilot_dotcom_pull_requests'] = self.copilot_dotcom_pull_requests.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if copilot_ide_code_completions (nullable) is None
        # and model_fields_set contains the field
        if self.copilot_ide_code_completions is None and "copilot_ide_code_completions" in self.model_fields_set:
            _dict['copilot_ide_code_completions'] = None

        # set to None if copilot_ide_chat (nullable) is None
        # and model_fields_set contains the field
        if self.copilot_ide_chat is None and "copilot_ide_chat" in self.model_fields_set:
            _dict['copilot_ide_chat'] = None

        # set to None if copilot_dotcom_chat (nullable) is None
        # and model_fields_set contains the field
        if self.copilot_dotcom_chat is None and "copilot_dotcom_chat" in self.model_fields_set:
            _dict['copilot_dotcom_chat'] = None

        # set to None if copilot_dotcom_pull_requests (nullable) is None
        # and model_fields_set contains the field
        if self.copilot_dotcom_pull_requests is None and "copilot_dotcom_pull_requests" in self.model_fields_set:
            _dict['copilot_dotcom_pull_requests'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CopilotUsageMetricsDay from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "total_active_users": obj.get("total_active_users"),
            "total_engaged_users": obj.get("total_engaged_users"),
            "copilot_ide_code_completions": CopilotIdeCodeCompletions.from_dict(obj["copilot_ide_code_completions"]) if obj.get("copilot_ide_code_completions") is not None else None,
            "copilot_ide_chat": CopilotIdeChat.from_dict(obj["copilot_ide_chat"]) if obj.get("copilot_ide_chat") is not None else None,
            "copilot_dotcom_chat": CopilotDotcomChat.from_dict(obj["copilot_dotcom_chat"]) if obj.get("copilot_dotcom_chat") is not None else None,
            "copilot_dotcom_pull_requests": CopilotDotcomPullRequests.from_dict(obj["copilot_dotcom_pull_requests"]) if obj.get("copilot_dotcom_pull_requests") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


