# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.cvss_severities_cvss_v3 import CvssSeveritiesCvssV3
from devopso.clients.github.models.cvss_severities_cvss_v4 import CvssSeveritiesCvssV4
from typing import Optional, Set
from typing_extensions import Self

class CvssSeverities(BaseModel):
    """
    CvssSeverities
    """ # noqa: E501
    cvss_v3: Optional[CvssSeveritiesCvssV3] = None
    cvss_v4: Optional[CvssSeveritiesCvssV4] = None
    __properties: ClassVar[List[str]] = ["cvss_v3", "cvss_v4"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CvssSeverities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cvss_v3
        if self.cvss_v3:
            _dict['cvss_v3'] = self.cvss_v3.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_v4
        if self.cvss_v4:
            _dict['cvss_v4'] = self.cvss_v4.to_dict()
        # set to None if cvss_v3 (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_v3 is None and "cvss_v3" in self.model_fields_set:
            _dict['cvss_v3'] = None

        # set to None if cvss_v4 (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_v4 is None and "cvss_v4" in self.model_fields_set:
            _dict['cvss_v4'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CvssSeverities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cvss_v3": CvssSeveritiesCvssV3.from_dict(obj["cvss_v3"]) if obj.get("cvss_v3") is not None else None,
            "cvss_v4": CvssSeveritiesCvssV4.from_dict(obj["cvss_v4"]) if obj.get("cvss_v4") is not None else None
        })
        return _obj


