# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.cvss_severities import CvssSeverities
from devopso.clients.github.models.dependabot_alert_security_advisory_cvss import DependabotAlertSecurityAdvisoryCvss
from devopso.clients.github.models.dependabot_alert_security_advisory_cwes_inner import DependabotAlertSecurityAdvisoryCwesInner
from devopso.clients.github.models.dependabot_alert_security_advisory_identifiers_inner import DependabotAlertSecurityAdvisoryIdentifiersInner
from devopso.clients.github.models.dependabot_alert_security_advisory_references_inner import DependabotAlertSecurityAdvisoryReferencesInner
from devopso.clients.github.models.dependabot_alert_security_vulnerability import DependabotAlertSecurityVulnerability
from devopso.clients.github.models.security_advisory_epss import SecurityAdvisoryEpss
from typing import Optional, Set
from typing_extensions import Self

class DependabotAlertSecurityAdvisory(BaseModel):
    """
    Details for the GitHub Security Advisory.
    """ # noqa: E501
    ghsa_id: StrictStr = Field(description="The unique GitHub Security Advisory ID assigned to the advisory.")
    cve_id: Optional[StrictStr] = Field(description="The unique CVE ID assigned to the advisory.")
    summary: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="A short, plain text summary of the advisory.")
    description: StrictStr = Field(description="A long-form Markdown-supported description of the advisory.")
    vulnerabilities: List[DependabotAlertSecurityVulnerability] = Field(description="Vulnerable version range information for the advisory.")
    severity: StrictStr = Field(description="The severity of the advisory.")
    cvss: DependabotAlertSecurityAdvisoryCvss
    cvss_severities: Optional[CvssSeverities] = None
    epss: Optional[SecurityAdvisoryEpss] = None
    cwes: List[DependabotAlertSecurityAdvisoryCwesInner] = Field(description="Details for the advisory pertaining to Common Weakness Enumeration.")
    identifiers: List[DependabotAlertSecurityAdvisoryIdentifiersInner] = Field(description="Values that identify this advisory among security information sources.")
    references: List[DependabotAlertSecurityAdvisoryReferencesInner] = Field(description="Links to additional advisory information.")
    published_at: datetime = Field(description="The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    updated_at: datetime = Field(description="The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    withdrawn_at: Optional[datetime] = Field(description="The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    __properties: ClassVar[List[str]] = ["ghsa_id", "cve_id", "summary", "description", "vulnerabilities", "severity", "cvss", "cvss_severities", "epss", "cwes", "identifiers", "references", "published_at", "updated_at", "withdrawn_at"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['low', 'medium', 'high', 'critical']):
            raise ValueError("must be one of enum values ('low', 'medium', 'high', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependabotAlertSecurityAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "ghsa_id",
            "cve_id",
            "summary",
            "description",
            "vulnerabilities",
            "severity",
            "cwes",
            "identifiers",
            "references",
            "published_at",
            "updated_at",
            "withdrawn_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # override the default output from pydantic by calling `to_dict()` of cvss
        if self.cvss:
            _dict['cvss'] = self.cvss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_severities
        if self.cvss_severities:
            _dict['cvss_severities'] = self.cvss_severities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of epss
        if self.epss:
            _dict['epss'] = self.epss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cwes (list)
        _items = []
        if self.cwes:
            for _item_cwes in self.cwes:
                if _item_cwes:
                    _items.append(_item_cwes.to_dict())
            _dict['cwes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item_references in self.references:
                if _item_references:
                    _items.append(_item_references.to_dict())
            _dict['references'] = _items
        # set to None if cve_id (nullable) is None
        # and model_fields_set contains the field
        if self.cve_id is None and "cve_id" in self.model_fields_set:
            _dict['cve_id'] = None

        # set to None if cvss_severities (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_severities is None and "cvss_severities" in self.model_fields_set:
            _dict['cvss_severities'] = None

        # set to None if epss (nullable) is None
        # and model_fields_set contains the field
        if self.epss is None and "epss" in self.model_fields_set:
            _dict['epss'] = None

        # set to None if withdrawn_at (nullable) is None
        # and model_fields_set contains the field
        if self.withdrawn_at is None and "withdrawn_at" in self.model_fields_set:
            _dict['withdrawn_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependabotAlertSecurityAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ghsa_id": obj.get("ghsa_id"),
            "cve_id": obj.get("cve_id"),
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "vulnerabilities": [DependabotAlertSecurityVulnerability.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "severity": obj.get("severity"),
            "cvss": DependabotAlertSecurityAdvisoryCvss.from_dict(obj["cvss"]) if obj.get("cvss") is not None else None,
            "cvss_severities": CvssSeverities.from_dict(obj["cvss_severities"]) if obj.get("cvss_severities") is not None else None,
            "epss": SecurityAdvisoryEpss.from_dict(obj["epss"]) if obj.get("epss") is not None else None,
            "cwes": [DependabotAlertSecurityAdvisoryCwesInner.from_dict(_item) for _item in obj["cwes"]] if obj.get("cwes") is not None else None,
            "identifiers": [DependabotAlertSecurityAdvisoryIdentifiersInner.from_dict(_item) for _item in obj["identifiers"]] if obj.get("identifiers") is not None else None,
            "references": [DependabotAlertSecurityAdvisoryReferencesInner.from_dict(_item) for _item in obj["references"]] if obj.get("references") is not None else None,
            "published_at": obj.get("published_at"),
            "updated_at": obj.get("updated_at"),
            "withdrawn_at": obj.get("withdrawn_at")
        })
        return _obj


