# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.dependabot_alert_security_advisory import DependabotAlertSecurityAdvisory
from devopso.clients.github.models.dependabot_alert_security_vulnerability import DependabotAlertSecurityVulnerability
from devopso.clients.github.models.dependabot_alert_with_repository_dependency import DependabotAlertWithRepositoryDependency
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.simple_repository import SimpleRepository
from typing import Optional, Set
from typing_extensions import Self

class DependabotAlertWithRepository(BaseModel):
    """
    A Dependabot alert.
    """ # noqa: E501
    number: StrictInt = Field(description="The security alert number.")
    state: StrictStr = Field(description="The state of the Dependabot alert.")
    dependency: DependabotAlertWithRepositoryDependency
    security_advisory: DependabotAlertSecurityAdvisory
    security_vulnerability: DependabotAlertSecurityVulnerability
    url: StrictStr = Field(description="The REST API URL of the alert resource.")
    html_url: StrictStr = Field(description="The GitHub URL of the alert resource.")
    created_at: datetime = Field(description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    updated_at: datetime = Field(description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    dismissed_at: Optional[datetime] = Field(description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    dismissed_by: Optional[NullableSimpleUser]
    dismissed_reason: Optional[StrictStr] = Field(description="The reason that the alert was dismissed.")
    dismissed_comment: Optional[Annotated[str, Field(strict=True, max_length=280)]] = Field(description="An optional comment associated with the alert's dismissal.")
    fixed_at: Optional[datetime] = Field(description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    auto_dismissed_at: Optional[datetime] = Field(default=None, description="The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.")
    repository: SimpleRepository
    __properties: ClassVar[List[str]] = ["number", "state", "dependency", "security_advisory", "security_vulnerability", "url", "html_url", "created_at", "updated_at", "dismissed_at", "dismissed_by", "dismissed_reason", "dismissed_comment", "fixed_at", "auto_dismissed_at", "repository"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['auto_dismissed', 'dismissed', 'fixed', 'open']):
            raise ValueError("must be one of enum values ('auto_dismissed', 'dismissed', 'fixed', 'open')")
        return value

    @field_validator('dismissed_reason')
    def dismissed_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['fix_started', 'inaccurate', 'no_bandwidth', 'not_used', 'tolerable_risk']):
            raise ValueError("must be one of enum values ('fix_started', 'inaccurate', 'no_bandwidth', 'not_used', 'tolerable_risk')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependabotAlertWithRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "number",
            "state",
            "url",
            "html_url",
            "created_at",
            "updated_at",
            "dismissed_at",
            "fixed_at",
            "auto_dismissed_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dependency
        if self.dependency:
            _dict['dependency'] = self.dependency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security_advisory
        if self.security_advisory:
            _dict['security_advisory'] = self.security_advisory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security_vulnerability
        if self.security_vulnerability:
            _dict['security_vulnerability'] = self.security_vulnerability.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dismissed_by
        if self.dismissed_by:
            _dict['dismissed_by'] = self.dismissed_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # set to None if dismissed_at (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_at is None and "dismissed_at" in self.model_fields_set:
            _dict['dismissed_at'] = None

        # set to None if dismissed_by (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_by is None and "dismissed_by" in self.model_fields_set:
            _dict['dismissed_by'] = None

        # set to None if dismissed_reason (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_reason is None and "dismissed_reason" in self.model_fields_set:
            _dict['dismissed_reason'] = None

        # set to None if dismissed_comment (nullable) is None
        # and model_fields_set contains the field
        if self.dismissed_comment is None and "dismissed_comment" in self.model_fields_set:
            _dict['dismissed_comment'] = None

        # set to None if fixed_at (nullable) is None
        # and model_fields_set contains the field
        if self.fixed_at is None and "fixed_at" in self.model_fields_set:
            _dict['fixed_at'] = None

        # set to None if auto_dismissed_at (nullable) is None
        # and model_fields_set contains the field
        if self.auto_dismissed_at is None and "auto_dismissed_at" in self.model_fields_set:
            _dict['auto_dismissed_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependabotAlertWithRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "state": obj.get("state"),
            "dependency": DependabotAlertWithRepositoryDependency.from_dict(obj["dependency"]) if obj.get("dependency") is not None else None,
            "security_advisory": DependabotAlertSecurityAdvisory.from_dict(obj["security_advisory"]) if obj.get("security_advisory") is not None else None,
            "security_vulnerability": DependabotAlertSecurityVulnerability.from_dict(obj["security_vulnerability"]) if obj.get("security_vulnerability") is not None else None,
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "dismissed_at": obj.get("dismissed_at"),
            "dismissed_by": NullableSimpleUser.from_dict(obj["dismissed_by"]) if obj.get("dismissed_by") is not None else None,
            "dismissed_reason": obj.get("dismissed_reason"),
            "dismissed_comment": obj.get("dismissed_comment"),
            "fixed_at": obj.get("fixed_at"),
            "auto_dismissed_at": obj.get("auto_dismissed_at"),
            "repository": SimpleRepository.from_dict(obj["repository"]) if obj.get("repository") is not None else None
        })
        return _obj


