# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.dependabot_alert_package import DependabotAlertPackage
from typing import Optional, Set
from typing_extensions import Self

class DependabotAlertWithRepositoryDependency(BaseModel):
    """
    Details for the vulnerable dependency.
    """ # noqa: E501
    package: Optional[DependabotAlertPackage] = None
    manifest_path: Optional[StrictStr] = Field(default=None, description="The full path to the dependency manifest file, relative to the root of the repository.")
    scope: Optional[StrictStr] = Field(default=None, description="The execution scope of the vulnerable dependency.")
    relationship: Optional[StrictStr] = Field(default=None, description="The vulnerable dependency's relationship to your project.  > [!NOTE] > We are rolling out support for dependency relationship across ecosystems. This value will be \"unknown\" for all dependencies in unsupported ecosystems. ")
    __properties: ClassVar[List[str]] = ["package", "manifest_path", "scope", "relationship"]

    @field_validator('scope')
    def scope_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['development', 'runtime']):
            raise ValueError("must be one of enum values ('development', 'runtime')")
        return value

    @field_validator('relationship')
    def relationship_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['unknown', 'direct', 'transitive']):
            raise ValueError("must be one of enum values ('unknown', 'direct', 'transitive')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependabotAlertWithRepositoryDependency from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "manifest_path",
            "scope",
            "relationship",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of package
        if self.package:
            _dict['package'] = self.package.to_dict()
        # set to None if scope (nullable) is None
        # and model_fields_set contains the field
        if self.scope is None and "scope" in self.model_fields_set:
            _dict['scope'] = None

        # set to None if relationship (nullable) is None
        # and model_fields_set contains the field
        if self.relationship is None and "relationship" in self.model_fields_set:
            _dict['relationship'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependabotAlertWithRepositoryDependency from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "package": DependabotAlertPackage.from_dict(obj["package"]) if obj.get("package") is not None else None,
            "manifest_path": obj.get("manifest_path"),
            "scope": obj.get("scope"),
            "relationship": obj.get("relationship")
        })
        return _obj


