# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.dependabot_create_or_update_org_secret_request_selected_repository_ids_inner import DependabotCreateOrUpdateOrgSecretRequestSelectedRepositoryIdsInner
from typing import Optional, Set
from typing_extensions import Self

class DependabotCreateOrUpdateOrgSecretRequest(BaseModel):
    """
    DependabotCreateOrUpdateOrgSecretRequest
    """ # noqa: E501
    encrypted_value: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/dependabot/secrets#get-an-organization-public-key) endpoint.")
    key_id: Optional[StrictStr] = Field(default=None, description="ID of the key you used to encrypt the secret.")
    visibility: StrictStr = Field(description="Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.")
    selected_repository_ids: Optional[List[DependabotCreateOrUpdateOrgSecretRequestSelectedRepositoryIdsInner]] = Field(default=None, description="An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints. Use integers when possible, as strings are supported only to maintain backwards compatibility and may be removed in the future.")
    __properties: ClassVar[List[str]] = ["encrypted_value", "key_id", "visibility", "selected_repository_ids"]

    @field_validator('encrypted_value')
    def encrypted_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{4})$", value):
            raise ValueError(r"must validate the regular expression /^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{4})$/")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['all', 'private', 'selected']):
            raise ValueError("must be one of enum values ('all', 'private', 'selected')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependabotCreateOrUpdateOrgSecretRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in selected_repository_ids (list)
        _items = []
        if self.selected_repository_ids:
            for _item_selected_repository_ids in self.selected_repository_ids:
                if _item_selected_repository_ids:
                    _items.append(_item_selected_repository_ids.to_dict())
            _dict['selected_repository_ids'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependabotCreateOrUpdateOrgSecretRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "encrypted_value": obj.get("encrypted_value"),
            "key_id": obj.get("key_id"),
            "visibility": obj.get("visibility"),
            "selected_repository_ids": [DependabotCreateOrUpdateOrgSecretRequestSelectedRepositoryIdsInner.from_dict(_item) for _item in obj["selected_repository_ids"]] if obj.get("selected_repository_ids") is not None else None
        })
        return _obj


