# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class DependabotUpdateAlertRequest(BaseModel):
    """
    DependabotUpdateAlertRequest
    """ # noqa: E501
    state: StrictStr = Field(description="The state of the Dependabot alert. A `dismissed_reason` must be provided when setting the state to `dismissed`.")
    dismissed_reason: Optional[StrictStr] = Field(default=None, description="**Required when `state` is `dismissed`.** A reason for dismissing the alert.")
    dismissed_comment: Optional[Annotated[str, Field(strict=True, max_length=280)]] = Field(default=None, description="An optional comment associated with dismissing the alert.")
    __properties: ClassVar[List[str]] = ["state", "dismissed_reason", "dismissed_comment"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['dismissed', 'open']):
            raise ValueError("must be one of enum values ('dismissed', 'open')")
        return value

    @field_validator('dismissed_reason')
    def dismissed_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['fix_started', 'inaccurate', 'no_bandwidth', 'not_used', 'tolerable_risk']):
            raise ValueError("must be one of enum values ('fix_started', 'inaccurate', 'no_bandwidth', 'not_used', 'tolerable_risk')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependabotUpdateAlertRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependabotUpdateAlertRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "dismissed_reason": obj.get("dismissed_reason"),
            "dismissed_comment": obj.get("dismissed_comment")
        })
        return _obj


