# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.metadata_value import MetadataValue
from typing import Optional, Set
from typing_extensions import Self

class Dependency(BaseModel):
    """
    Dependency
    """ # noqa: E501
    package_url: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.")
    metadata: Optional[Dict[str, Optional[MetadataValue]]] = Field(default=None, description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.")
    relationship: Optional[StrictStr] = Field(default=None, description="A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.")
    scope: Optional[StrictStr] = Field(default=None, description="A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.")
    dependencies: Optional[List[StrictStr]] = Field(default=None, description="Array of package-url (PURLs) of direct child dependencies.")
    __properties: ClassVar[List[str]] = ["package_url", "metadata", "relationship", "scope", "dependencies"]

    @field_validator('package_url')
    def package_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^pkg", value):
            raise ValueError(r"must validate the regular expression /^pkg/")
        return value

    @field_validator('relationship')
    def relationship_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['direct', 'indirect']):
            raise ValueError("must be one of enum values ('direct', 'indirect')")
        return value

    @field_validator('scope')
    def scope_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['runtime', 'development']):
            raise ValueError("must be one of enum values ('runtime', 'development')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Dependency from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in metadata (dict)
        _field_dict = {}
        if self.metadata:
            for _key_metadata in self.metadata:
                if self.metadata[_key_metadata]:
                    _field_dict[_key_metadata] = self.metadata[_key_metadata].to_dict()
            _dict['metadata'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Dependency from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "package_url": obj.get("package_url"),
            "metadata": dict(
                (_k, MetadataValue.from_dict(_v))
                for _k, _v in obj["metadata"].items()
            )
            if obj.get("metadata") is not None
            else None,
            "relationship": obj.get("relationship"),
            "scope": obj.get("scope"),
            "dependencies": obj.get("dependencies")
        })
        return _obj


