# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.dependency_graph_diff_inner_vulnerabilities_inner import DependencyGraphDiffInnerVulnerabilitiesInner
from typing import Optional, Set
from typing_extensions import Self

class DependencyGraphDiffInner(BaseModel):
    """
    DependencyGraphDiffInner
    """ # noqa: E501
    change_type: StrictStr
    manifest: StrictStr
    ecosystem: StrictStr
    name: StrictStr
    version: StrictStr
    package_url: Optional[StrictStr]
    license: Optional[StrictStr]
    source_repository_url: Optional[StrictStr]
    vulnerabilities: List[DependencyGraphDiffInnerVulnerabilitiesInner]
    scope: StrictStr = Field(description="Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.")
    __properties: ClassVar[List[str]] = ["change_type", "manifest", "ecosystem", "name", "version", "package_url", "license", "source_repository_url", "vulnerabilities", "scope"]

    @field_validator('change_type')
    def change_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['added', 'removed']):
            raise ValueError("must be one of enum values ('added', 'removed')")
        return value

    @field_validator('scope')
    def scope_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['unknown', 'runtime', 'development']):
            raise ValueError("must be one of enum values ('unknown', 'runtime', 'development')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependencyGraphDiffInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # set to None if package_url (nullable) is None
        # and model_fields_set contains the field
        if self.package_url is None and "package_url" in self.model_fields_set:
            _dict['package_url'] = None

        # set to None if license (nullable) is None
        # and model_fields_set contains the field
        if self.license is None and "license" in self.model_fields_set:
            _dict['license'] = None

        # set to None if source_repository_url (nullable) is None
        # and model_fields_set contains the field
        if self.source_repository_url is None and "source_repository_url" in self.model_fields_set:
            _dict['source_repository_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependencyGraphDiffInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "change_type": obj.get("change_type"),
            "manifest": obj.get("manifest"),
            "ecosystem": obj.get("ecosystem"),
            "name": obj.get("name"),
            "version": obj.get("version"),
            "package_url": obj.get("package_url"),
            "license": obj.get("license"),
            "source_repository_url": obj.get("source_repository_url"),
            "vulnerabilities": [DependencyGraphDiffInnerVulnerabilitiesInner.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "scope": obj.get("scope")
        })
        return _obj


