# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.dependency_graph_spdx_sbom_sbom_creation_info import DependencyGraphSpdxSbomSbomCreationInfo
from devopso.clients.github.models.dependency_graph_spdx_sbom_sbom_packages_inner import DependencyGraphSpdxSbomSbomPackagesInner
from devopso.clients.github.models.dependency_graph_spdx_sbom_sbom_relationships_inner import DependencyGraphSpdxSbomSbomRelationshipsInner
from typing import Optional, Set
from typing_extensions import Self

class DependencyGraphSpdxSbomSbom(BaseModel):
    """
    DependencyGraphSpdxSbomSbom
    """ # noqa: E501
    spdxid: StrictStr = Field(description="The SPDX identifier for the SPDX document.", alias="SPDXID")
    spdx_version: StrictStr = Field(description="The version of the SPDX specification that this document conforms to.", alias="spdxVersion")
    comment: Optional[StrictStr] = Field(default=None, description="An optional comment about the SPDX document.")
    creation_info: DependencyGraphSpdxSbomSbomCreationInfo = Field(alias="creationInfo")
    name: StrictStr = Field(description="The name of the SPDX document.")
    data_license: StrictStr = Field(description="The license under which the SPDX document is licensed.", alias="dataLicense")
    document_namespace: StrictStr = Field(description="The namespace for the SPDX document.", alias="documentNamespace")
    packages: List[DependencyGraphSpdxSbomSbomPackagesInner]
    relationships: Optional[List[DependencyGraphSpdxSbomSbomRelationshipsInner]] = None
    __properties: ClassVar[List[str]] = ["SPDXID", "spdxVersion", "comment", "creationInfo", "name", "dataLicense", "documentNamespace", "packages", "relationships"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependencyGraphSpdxSbomSbom from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creation_info
        if self.creation_info:
            _dict['creationInfo'] = self.creation_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in packages (list)
        _items = []
        if self.packages:
            for _item_packages in self.packages:
                if _item_packages:
                    _items.append(_item_packages.to_dict())
            _dict['packages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relationships (list)
        _items = []
        if self.relationships:
            for _item_relationships in self.relationships:
                if _item_relationships:
                    _items.append(_item_relationships.to_dict())
            _dict['relationships'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependencyGraphSpdxSbomSbom from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SPDXID": obj.get("SPDXID"),
            "spdxVersion": obj.get("spdxVersion"),
            "comment": obj.get("comment"),
            "creationInfo": DependencyGraphSpdxSbomSbomCreationInfo.from_dict(obj["creationInfo"]) if obj.get("creationInfo") is not None else None,
            "name": obj.get("name"),
            "dataLicense": obj.get("dataLicense"),
            "documentNamespace": obj.get("documentNamespace"),
            "packages": [DependencyGraphSpdxSbomSbomPackagesInner.from_dict(_item) for _item in obj["packages"]] if obj.get("packages") is not None else None,
            "relationships": [DependencyGraphSpdxSbomSbomRelationshipsInner.from_dict(_item) for _item in obj["relationships"]] if obj.get("relationships") is not None else None
        })
        return _obj


