# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.dependency_graph_spdx_sbom_sbom_packages_inner_external_refs_inner import DependencyGraphSpdxSbomSbomPackagesInnerExternalRefsInner
from typing import Optional, Set
from typing_extensions import Self

class DependencyGraphSpdxSbomSbomPackagesInner(BaseModel):
    """
    DependencyGraphSpdxSbomSbomPackagesInner
    """ # noqa: E501
    spdxid: Optional[StrictStr] = Field(default=None, description="A unique SPDX identifier for the package.", alias="SPDXID")
    name: Optional[StrictStr] = Field(default=None, description="The name of the package.")
    version_info: Optional[StrictStr] = Field(default=None, description="The version of the package. If the package does not have an exact version specified, a version range is given.", alias="versionInfo")
    download_location: Optional[StrictStr] = Field(default=None, description="The location where the package can be downloaded, or NOASSERTION if this has not been determined.", alias="downloadLocation")
    files_analyzed: Optional[StrictBool] = Field(default=None, description="Whether the package's file content has been subjected to analysis during the creation of the SPDX document.", alias="filesAnalyzed")
    license_concluded: Optional[StrictStr] = Field(default=None, description="The license of the package as determined while creating the SPDX document.", alias="licenseConcluded")
    license_declared: Optional[StrictStr] = Field(default=None, description="The license of the package as declared by its author, or NOASSERTION if this information was not available when the SPDX document was created.", alias="licenseDeclared")
    supplier: Optional[StrictStr] = Field(default=None, description="The distribution source of this package, or NOASSERTION if this was not determined.")
    copyright_text: Optional[StrictStr] = Field(default=None, description="The copyright holders of the package, and any dates present with those notices, if available.", alias="copyrightText")
    external_refs: Optional[List[DependencyGraphSpdxSbomSbomPackagesInnerExternalRefsInner]] = Field(default=None, alias="externalRefs")
    __properties: ClassVar[List[str]] = ["SPDXID", "name", "versionInfo", "downloadLocation", "filesAnalyzed", "licenseConcluded", "licenseDeclared", "supplier", "copyrightText", "externalRefs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DependencyGraphSpdxSbomSbomPackagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in external_refs (list)
        _items = []
        if self.external_refs:
            for _item_external_refs in self.external_refs:
                if _item_external_refs:
                    _items.append(_item_external_refs.to_dict())
            _dict['externalRefs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DependencyGraphSpdxSbomSbomPackagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SPDXID": obj.get("SPDXID"),
            "name": obj.get("name"),
            "versionInfo": obj.get("versionInfo"),
            "downloadLocation": obj.get("downloadLocation"),
            "filesAnalyzed": obj.get("filesAnalyzed"),
            "licenseConcluded": obj.get("licenseConcluded"),
            "licenseDeclared": obj.get("licenseDeclared"),
            "supplier": obj.get("supplier"),
            "copyrightText": obj.get("copyrightText"),
            "externalRefs": [DependencyGraphSpdxSbomSbomPackagesInnerExternalRefsInner.from_dict(_item) for _item in obj["externalRefs"]] if obj.get("externalRefs") is not None else None
        })
        return _obj


