# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.app5 import App5
from devopso.clients.github.models.deployment_payload import DeploymentPayload
from devopso.clients.github.models.user2 import User2
from typing import Optional, Set
from typing_extensions import Self

class Deployment(BaseModel):
    """
    The [deployment](https://docs.github.com/rest/deployments/deployments#list-deployments).
    """ # noqa: E501
    created_at: StrictStr
    creator: Optional[User2]
    description: Optional[StrictStr]
    environment: StrictStr
    id: StrictInt
    node_id: StrictStr
    original_environment: StrictStr
    payload: DeploymentPayload
    performed_via_github_app: Optional[App5] = None
    production_environment: Optional[StrictBool] = None
    ref: StrictStr
    repository_url: StrictStr
    sha: StrictStr
    statuses_url: StrictStr
    task: StrictStr
    transient_environment: Optional[StrictBool] = None
    updated_at: StrictStr
    url: StrictStr
    __properties: ClassVar[List[str]] = ["created_at", "creator", "description", "environment", "id", "node_id", "original_environment", "payload", "performed_via_github_app", "production_environment", "ref", "repository_url", "sha", "statuses_url", "task", "transient_environment", "updated_at", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Deployment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creator
        if self.creator:
            _dict['creator'] = self.creator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of performed_via_github_app
        if self.performed_via_github_app:
            _dict['performed_via_github_app'] = self.performed_via_github_app.to_dict()
        # set to None if creator (nullable) is None
        # and model_fields_set contains the field
        if self.creator is None and "creator" in self.model_fields_set:
            _dict['creator'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if performed_via_github_app (nullable) is None
        # and model_fields_set contains the field
        if self.performed_via_github_app is None and "performed_via_github_app" in self.model_fields_set:
            _dict['performed_via_github_app'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Deployment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "creator": User2.from_dict(obj["creator"]) if obj.get("creator") is not None else None,
            "description": obj.get("description"),
            "environment": obj.get("environment"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "original_environment": obj.get("original_environment"),
            "payload": DeploymentPayload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "performed_via_github_app": App5.from_dict(obj["performed_via_github_app"]) if obj.get("performed_via_github_app") is not None else None,
            "production_environment": obj.get("production_environment"),
            "ref": obj.get("ref"),
            "repository_url": obj.get("repository_url"),
            "sha": obj.get("sha"),
            "statuses_url": obj.get("statuses_url"),
            "task": obj.get("task"),
            "transient_environment": obj.get("transient_environment"),
            "updated_at": obj.get("updated_at"),
            "url": obj.get("url")
        })
        return _obj


