# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.discussion_category import DiscussionCategory
from devopso.clients.github.models.label import Label
from devopso.clients.github.models.reactions import Reactions
from devopso.clients.github.models.user1 import User1
from devopso.clients.github.models.user2 import User2
from typing import Optional, Set
from typing_extensions import Self

class Discussion(BaseModel):
    """
    A Discussion in a repository.
    """ # noqa: E501
    active_lock_reason: Optional[StrictStr]
    answer_chosen_at: Optional[StrictStr]
    answer_chosen_by: Optional[User2]
    answer_html_url: Optional[StrictStr]
    author_association: StrictStr = Field(description="How the author is associated with the repository.")
    body: StrictStr
    category: DiscussionCategory
    comments: StrictInt
    created_at: datetime
    html_url: StrictStr
    id: StrictInt
    locked: StrictBool
    node_id: StrictStr
    number: StrictInt
    reactions: Optional[Reactions] = None
    repository_url: StrictStr
    state: StrictStr = Field(description="The current state of the discussion. `converting` means that the discussion is being converted from an issue. `transferring` means that the discussion is being transferred from another repository.")
    state_reason: Optional[StrictStr] = Field(description="The reason for the current state")
    timeline_url: Optional[StrictStr] = None
    title: StrictStr
    updated_at: datetime
    user: Optional[User1]
    labels: Optional[List[Label]] = None
    __properties: ClassVar[List[str]] = ["active_lock_reason", "answer_chosen_at", "answer_chosen_by", "answer_html_url", "author_association", "body", "category", "comments", "created_at", "html_url", "id", "locked", "node_id", "number", "reactions", "repository_url", "state", "state_reason", "timeline_url", "title", "updated_at", "user", "labels"]

    @field_validator('author_association')
    def author_association_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['COLLABORATOR', 'CONTRIBUTOR', 'FIRST_TIMER', 'FIRST_TIME_CONTRIBUTOR', 'MANNEQUIN', 'MEMBER', 'NONE', 'OWNER']):
            raise ValueError("must be one of enum values ('COLLABORATOR', 'CONTRIBUTOR', 'FIRST_TIMER', 'FIRST_TIME_CONTRIBUTOR', 'MANNEQUIN', 'MEMBER', 'NONE', 'OWNER')")
        return value

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'closed', 'locked', 'converting', 'transferring']):
            raise ValueError("must be one of enum values ('open', 'closed', 'locked', 'converting', 'transferring')")
        return value

    @field_validator('state_reason')
    def state_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['resolved', 'outdated', 'duplicate', 'reopened']):
            raise ValueError("must be one of enum values ('resolved', 'outdated', 'duplicate', 'reopened')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Discussion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of answer_chosen_by
        if self.answer_chosen_by:
            _dict['answer_chosen_by'] = self.answer_chosen_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict['category'] = self.category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reactions
        if self.reactions:
            _dict['reactions'] = self.reactions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # set to None if active_lock_reason (nullable) is None
        # and model_fields_set contains the field
        if self.active_lock_reason is None and "active_lock_reason" in self.model_fields_set:
            _dict['active_lock_reason'] = None

        # set to None if answer_chosen_at (nullable) is None
        # and model_fields_set contains the field
        if self.answer_chosen_at is None and "answer_chosen_at" in self.model_fields_set:
            _dict['answer_chosen_at'] = None

        # set to None if answer_chosen_by (nullable) is None
        # and model_fields_set contains the field
        if self.answer_chosen_by is None and "answer_chosen_by" in self.model_fields_set:
            _dict['answer_chosen_by'] = None

        # set to None if answer_html_url (nullable) is None
        # and model_fields_set contains the field
        if self.answer_html_url is None and "answer_html_url" in self.model_fields_set:
            _dict['answer_html_url'] = None

        # set to None if state_reason (nullable) is None
        # and model_fields_set contains the field
        if self.state_reason is None and "state_reason" in self.model_fields_set:
            _dict['state_reason'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Discussion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active_lock_reason": obj.get("active_lock_reason"),
            "answer_chosen_at": obj.get("answer_chosen_at"),
            "answer_chosen_by": User2.from_dict(obj["answer_chosen_by"]) if obj.get("answer_chosen_by") is not None else None,
            "answer_html_url": obj.get("answer_html_url"),
            "author_association": obj.get("author_association"),
            "body": obj.get("body"),
            "category": DiscussionCategory.from_dict(obj["category"]) if obj.get("category") is not None else None,
            "comments": obj.get("comments"),
            "created_at": obj.get("created_at"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "locked": obj.get("locked"),
            "node_id": obj.get("node_id"),
            "number": obj.get("number"),
            "reactions": Reactions.from_dict(obj["reactions"]) if obj.get("reactions") is not None else None,
            "repository_url": obj.get("repository_url"),
            "state": obj.get("state"),
            "state_reason": obj.get("state_reason"),
            "timeline_url": obj.get("timeline_url"),
            "title": obj.get("title"),
            "updated_at": obj.get("updated_at"),
            "user": User1.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "labels": [Label.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None
        })
        return _obj


