# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from devopso.clients.github.models.environment_approvals_environments_inner import EnvironmentApprovalsEnvironmentsInner
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class EnvironmentApprovals(BaseModel):
    """
    An entry in the reviews log for environment deployments
    """ # noqa: E501
    environments: List[EnvironmentApprovalsEnvironmentsInner] = Field(description="The list of environments that were approved or rejected")
    state: StrictStr = Field(description="Whether deployment to the environment(s) was approved or rejected or pending (with comments)")
    user: SimpleUser
    comment: StrictStr = Field(description="The comment submitted with the deployment review")
    __properties: ClassVar[List[str]] = ["environments", "state", "user", "comment"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['approved', 'rejected', 'pending']):
            raise ValueError("must be one of enum values ('approved', 'rejected', 'pending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EnvironmentApprovals from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environments (list)
        _items = []
        if self.environments:
            for _item_environments in self.environments:
                if _item_environments:
                    _items.append(_item_environments.to_dict())
            _dict['environments'] = _items
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EnvironmentApprovals from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "environments": [EnvironmentApprovalsEnvironmentsInner.from_dict(_item) for _item in obj["environments"]] if obj.get("environments") is not None else None,
            "state": obj.get("state"),
            "user": SimpleUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "comment": obj.get("comment")
        })
        return _obj


