# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.gist import Gist
from devopso.clients.github.models.gist_history import GistHistory
from devopso.clients.github.models.gist_simple_files_value import GistSimpleFilesValue
from devopso.clients.github.models.gist_simple_forks_inner import GistSimpleForksInner
from devopso.clients.github.models.simple_user import SimpleUser
from typing import Optional, Set
from typing_extensions import Self

class GistSimple(BaseModel):
    """
    Gist Simple
    """ # noqa: E501
    forks: Optional[List[GistSimpleForksInner]] = None
    history: Optional[List[GistHistory]] = None
    fork_of: Optional[Gist] = None
    url: Optional[StrictStr] = None
    forks_url: Optional[StrictStr] = None
    commits_url: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    node_id: Optional[StrictStr] = None
    git_pull_url: Optional[StrictStr] = None
    git_push_url: Optional[StrictStr] = None
    html_url: Optional[StrictStr] = None
    files: Optional[Dict[str, Optional[GistSimpleFilesValue]]] = None
    public: Optional[StrictBool] = None
    created_at: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    comments: Optional[StrictInt] = None
    comments_enabled: Optional[StrictBool] = None
    user: Optional[StrictStr] = None
    comments_url: Optional[StrictStr] = None
    owner: Optional[SimpleUser] = None
    truncated: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["forks", "history", "fork_of", "url", "forks_url", "commits_url", "id", "node_id", "git_pull_url", "git_push_url", "html_url", "files", "public", "created_at", "updated_at", "description", "comments", "comments_enabled", "user", "comments_url", "owner", "truncated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GistSimple from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in forks (list)
        _items = []
        if self.forks:
            for _item_forks in self.forks:
                if _item_forks:
                    _items.append(_item_forks.to_dict())
            _dict['forks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item_history in self.history:
                if _item_history:
                    _items.append(_item_history.to_dict())
            _dict['history'] = _items
        # override the default output from pydantic by calling `to_dict()` of fork_of
        if self.fork_of:
            _dict['fork_of'] = self.fork_of.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in files (dict)
        _field_dict = {}
        if self.files:
            for _key_files in self.files:
                if self.files[_key_files]:
                    _field_dict[_key_files] = self.files[_key_files].to_dict()
            _dict['files'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # set to None if forks (nullable) is None
        # and model_fields_set contains the field
        if self.forks is None and "forks" in self.model_fields_set:
            _dict['forks'] = None

        # set to None if history (nullable) is None
        # and model_fields_set contains the field
        if self.history is None and "history" in self.model_fields_set:
            _dict['history'] = None

        # set to None if fork_of (nullable) is None
        # and model_fields_set contains the field
        if self.fork_of is None and "fork_of" in self.model_fields_set:
            _dict['fork_of'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GistSimple from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "forks": [GistSimpleForksInner.from_dict(_item) for _item in obj["forks"]] if obj.get("forks") is not None else None,
            "history": [GistHistory.from_dict(_item) for _item in obj["history"]] if obj.get("history") is not None else None,
            "fork_of": Gist.from_dict(obj["fork_of"]) if obj.get("fork_of") is not None else None,
            "url": obj.get("url"),
            "forks_url": obj.get("forks_url"),
            "commits_url": obj.get("commits_url"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "git_pull_url": obj.get("git_pull_url"),
            "git_push_url": obj.get("git_push_url"),
            "html_url": obj.get("html_url"),
            "files": dict(
                (_k, GistSimpleFilesValue.from_dict(_v))
                for _k, _v in obj["files"].items()
            )
            if obj.get("files") is not None
            else None,
            "public": obj.get("public"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "description": obj.get("description"),
            "comments": obj.get("comments"),
            "comments_enabled": obj.get("comments_enabled"),
            "user": obj.get("user"),
            "comments_url": obj.get("comments_url"),
            "owner": SimpleUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "truncated": obj.get("truncated")
        })
        return _obj


