# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.git_create_tag_request_tagger import GitCreateTagRequestTagger
from typing import Optional, Set
from typing_extensions import Self

class GitCreateTagRequest(BaseModel):
    """
    GitCreateTagRequest
    """ # noqa: E501
    tag: StrictStr = Field(description="The tag's name. This is typically a version (e.g., \"v0.0.1\").")
    message: StrictStr = Field(description="The tag message.")
    object: StrictStr = Field(description="The SHA of the git object this is tagging.")
    type: StrictStr = Field(description="The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.")
    tagger: Optional[GitCreateTagRequestTagger] = None
    __properties: ClassVar[List[str]] = ["tag", "message", "object", "type", "tagger"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['commit', 'tree', 'blob']):
            raise ValueError("must be one of enum values ('commit', 'tree', 'blob')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GitCreateTagRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tagger
        if self.tagger:
            _dict['tagger'] = self.tagger.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GitCreateTagRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tag": obj.get("tag"),
            "message": obj.get("message"),
            "object": obj.get("object"),
            "type": obj.get("type"),
            "tagger": GitCreateTagRequestTagger.from_dict(obj["tagger"]) if obj.get("tagger") is not None else None
        })
        return _obj


