# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.git_tag_object import GitTagObject
from devopso.clients.github.models.git_tag_tagger import GitTagTagger
from devopso.clients.github.models.verification import Verification
from typing import Optional, Set
from typing_extensions import Self

class GitTag(BaseModel):
    """
    Metadata for a Git tag
    """ # noqa: E501
    node_id: StrictStr
    tag: StrictStr = Field(description="Name of the tag")
    sha: StrictStr
    url: StrictStr = Field(description="URL for the tag")
    message: StrictStr = Field(description="Message describing the purpose of the tag")
    tagger: GitTagTagger
    object: GitTagObject
    verification: Optional[Verification] = None
    __properties: ClassVar[List[str]] = ["node_id", "tag", "sha", "url", "message", "tagger", "object", "verification"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GitTag from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tagger
        if self.tagger:
            _dict['tagger'] = self.tagger.to_dict()
        # override the default output from pydantic by calling `to_dict()` of object
        if self.object:
            _dict['object'] = self.object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of verification
        if self.verification:
            _dict['verification'] = self.verification.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GitTag from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "node_id": obj.get("node_id"),
            "tag": obj.get("tag"),
            "sha": obj.get("sha"),
            "url": obj.get("url"),
            "message": obj.get("message"),
            "tagger": GitTagTagger.from_dict(obj["tagger"]) if obj.get("tagger") is not None else None,
            "object": GitTagObject.from_dict(obj["object"]) if obj.get("object") is not None else None,
            "verification": Verification.from_dict(obj["verification"]) if obj.get("verification") is not None else None
        })
        return _obj


