# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.cvss_severities import CvssSeverities
from devopso.clients.github.models.global_advisory_credits_inner import GlobalAdvisoryCreditsInner
from devopso.clients.github.models.global_advisory_cvss import GlobalAdvisoryCvss
from devopso.clients.github.models.global_advisory_cwes_inner import GlobalAdvisoryCwesInner
from devopso.clients.github.models.global_advisory_identifiers_inner import GlobalAdvisoryIdentifiersInner
from devopso.clients.github.models.security_advisory_epss import SecurityAdvisoryEpss
from devopso.clients.github.models.vulnerability import Vulnerability
from typing import Optional, Set
from typing_extensions import Self

class GlobalAdvisory(BaseModel):
    """
    A GitHub Security Advisory.
    """ # noqa: E501
    ghsa_id: StrictStr = Field(description="The GitHub Security Advisory ID.")
    cve_id: Optional[StrictStr] = Field(description="The Common Vulnerabilities and Exposures (CVE) ID.")
    url: StrictStr = Field(description="The API URL for the advisory.")
    html_url: StrictStr = Field(description="The URL for the advisory.")
    repository_advisory_url: Optional[StrictStr] = Field(description="The API URL for the repository advisory.")
    summary: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="A short summary of the advisory.")
    description: Optional[Annotated[str, Field(strict=True, max_length=65535)]] = Field(description="A detailed description of what the advisory entails.")
    type: StrictStr = Field(description="The type of advisory.")
    severity: StrictStr = Field(description="The severity of the advisory.")
    source_code_location: Optional[StrictStr] = Field(description="The URL of the advisory's source code.")
    identifiers: Optional[List[GlobalAdvisoryIdentifiersInner]]
    references: Optional[List[StrictStr]]
    published_at: datetime = Field(description="The date and time of when the advisory was published, in ISO 8601 format.")
    updated_at: datetime = Field(description="The date and time of when the advisory was last updated, in ISO 8601 format.")
    github_reviewed_at: Optional[datetime] = Field(description="The date and time of when the advisory was reviewed by GitHub, in ISO 8601 format.")
    nvd_published_at: Optional[datetime] = Field(description="The date and time when the advisory was published in the National Vulnerability Database, in ISO 8601 format. This field is only populated when the advisory is imported from the National Vulnerability Database.")
    withdrawn_at: Optional[datetime] = Field(description="The date and time of when the advisory was withdrawn, in ISO 8601 format.")
    vulnerabilities: Optional[List[Vulnerability]] = Field(description="The products and respective version ranges affected by the advisory.")
    cvss: Optional[GlobalAdvisoryCvss]
    cvss_severities: Optional[CvssSeverities] = None
    epss: Optional[SecurityAdvisoryEpss] = None
    cwes: Optional[List[GlobalAdvisoryCwesInner]]
    credits: Optional[List[GlobalAdvisoryCreditsInner]] = Field(description="The users who contributed to the advisory.")
    __properties: ClassVar[List[str]] = ["ghsa_id", "cve_id", "url", "html_url", "repository_advisory_url", "summary", "description", "type", "severity", "source_code_location", "identifiers", "references", "published_at", "updated_at", "github_reviewed_at", "nvd_published_at", "withdrawn_at", "vulnerabilities", "cvss", "cvss_severities", "epss", "cwes", "credits"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['reviewed', 'unreviewed', 'malware']):
            raise ValueError("must be one of enum values ('reviewed', 'unreviewed', 'malware')")
        return value

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['critical', 'high', 'medium', 'low', 'unknown']):
            raise ValueError("must be one of enum values ('critical', 'high', 'medium', 'low', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GlobalAdvisory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "ghsa_id",
            "cve_id",
            "url",
            "html_url",
            "repository_advisory_url",
            "type",
            "identifiers",
            "published_at",
            "updated_at",
            "github_reviewed_at",
            "nvd_published_at",
            "withdrawn_at",
            "credits",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vulnerabilities (list)
        _items = []
        if self.vulnerabilities:
            for _item_vulnerabilities in self.vulnerabilities:
                if _item_vulnerabilities:
                    _items.append(_item_vulnerabilities.to_dict())
            _dict['vulnerabilities'] = _items
        # override the default output from pydantic by calling `to_dict()` of cvss
        if self.cvss:
            _dict['cvss'] = self.cvss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cvss_severities
        if self.cvss_severities:
            _dict['cvss_severities'] = self.cvss_severities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of epss
        if self.epss:
            _dict['epss'] = self.epss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cwes (list)
        _items = []
        if self.cwes:
            for _item_cwes in self.cwes:
                if _item_cwes:
                    _items.append(_item_cwes.to_dict())
            _dict['cwes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credits (list)
        _items = []
        if self.credits:
            for _item_credits in self.credits:
                if _item_credits:
                    _items.append(_item_credits.to_dict())
            _dict['credits'] = _items
        # set to None if cve_id (nullable) is None
        # and model_fields_set contains the field
        if self.cve_id is None and "cve_id" in self.model_fields_set:
            _dict['cve_id'] = None

        # set to None if repository_advisory_url (nullable) is None
        # and model_fields_set contains the field
        if self.repository_advisory_url is None and "repository_advisory_url" in self.model_fields_set:
            _dict['repository_advisory_url'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if source_code_location (nullable) is None
        # and model_fields_set contains the field
        if self.source_code_location is None and "source_code_location" in self.model_fields_set:
            _dict['source_code_location'] = None

        # set to None if identifiers (nullable) is None
        # and model_fields_set contains the field
        if self.identifiers is None and "identifiers" in self.model_fields_set:
            _dict['identifiers'] = None

        # set to None if references (nullable) is None
        # and model_fields_set contains the field
        if self.references is None and "references" in self.model_fields_set:
            _dict['references'] = None

        # set to None if github_reviewed_at (nullable) is None
        # and model_fields_set contains the field
        if self.github_reviewed_at is None and "github_reviewed_at" in self.model_fields_set:
            _dict['github_reviewed_at'] = None

        # set to None if nvd_published_at (nullable) is None
        # and model_fields_set contains the field
        if self.nvd_published_at is None and "nvd_published_at" in self.model_fields_set:
            _dict['nvd_published_at'] = None

        # set to None if withdrawn_at (nullable) is None
        # and model_fields_set contains the field
        if self.withdrawn_at is None and "withdrawn_at" in self.model_fields_set:
            _dict['withdrawn_at'] = None

        # set to None if vulnerabilities (nullable) is None
        # and model_fields_set contains the field
        if self.vulnerabilities is None and "vulnerabilities" in self.model_fields_set:
            _dict['vulnerabilities'] = None

        # set to None if cvss (nullable) is None
        # and model_fields_set contains the field
        if self.cvss is None and "cvss" in self.model_fields_set:
            _dict['cvss'] = None

        # set to None if cvss_severities (nullable) is None
        # and model_fields_set contains the field
        if self.cvss_severities is None and "cvss_severities" in self.model_fields_set:
            _dict['cvss_severities'] = None

        # set to None if epss (nullable) is None
        # and model_fields_set contains the field
        if self.epss is None and "epss" in self.model_fields_set:
            _dict['epss'] = None

        # set to None if cwes (nullable) is None
        # and model_fields_set contains the field
        if self.cwes is None and "cwes" in self.model_fields_set:
            _dict['cwes'] = None

        # set to None if credits (nullable) is None
        # and model_fields_set contains the field
        if self.credits is None and "credits" in self.model_fields_set:
            _dict['credits'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GlobalAdvisory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ghsa_id": obj.get("ghsa_id"),
            "cve_id": obj.get("cve_id"),
            "url": obj.get("url"),
            "html_url": obj.get("html_url"),
            "repository_advisory_url": obj.get("repository_advisory_url"),
            "summary": obj.get("summary"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "severity": obj.get("severity"),
            "source_code_location": obj.get("source_code_location"),
            "identifiers": [GlobalAdvisoryIdentifiersInner.from_dict(_item) for _item in obj["identifiers"]] if obj.get("identifiers") is not None else None,
            "references": obj.get("references"),
            "published_at": obj.get("published_at"),
            "updated_at": obj.get("updated_at"),
            "github_reviewed_at": obj.get("github_reviewed_at"),
            "nvd_published_at": obj.get("nvd_published_at"),
            "withdrawn_at": obj.get("withdrawn_at"),
            "vulnerabilities": [Vulnerability.from_dict(_item) for _item in obj["vulnerabilities"]] if obj.get("vulnerabilities") is not None else None,
            "cvss": GlobalAdvisoryCvss.from_dict(obj["cvss"]) if obj.get("cvss") is not None else None,
            "cvss_severities": CvssSeverities.from_dict(obj["cvss_severities"]) if obj.get("cvss_severities") is not None else None,
            "epss": SecurityAdvisoryEpss.from_dict(obj["epss"]) if obj.get("epss") is not None else None,
            "cwes": [GlobalAdvisoryCwesInner.from_dict(_item) for _item in obj["cwes"]] if obj.get("cwes") is not None else None,
            "credits": [GlobalAdvisoryCreditsInner.from_dict(_item) for _item in obj["credits"]] if obj.get("credits") is not None else None
        })
        return _obj


