# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.hook_response import HookResponse
from devopso.clients.github.models.webhook_config import WebhookConfig
from typing import Optional, Set
from typing_extensions import Self

class Hook(BaseModel):
    """
    Webhooks for repositories.
    """ # noqa: E501
    type: StrictStr
    id: StrictInt = Field(description="Unique identifier of the webhook.")
    name: StrictStr = Field(description="The name of a valid service, use 'web' for a webhook.")
    active: StrictBool = Field(description="Determines whether the hook is actually triggered on pushes.")
    events: List[StrictStr] = Field(description="Determines what events the hook is triggered for. Default: ['push'].")
    config: WebhookConfig
    updated_at: datetime
    created_at: datetime
    url: StrictStr
    test_url: StrictStr
    ping_url: StrictStr
    deliveries_url: Optional[StrictStr] = None
    last_response: HookResponse
    __properties: ClassVar[List[str]] = ["type", "id", "name", "active", "events", "config", "updated_at", "created_at", "url", "test_url", "ping_url", "deliveries_url", "last_response"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Hook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_response
        if self.last_response:
            _dict['last_response'] = self.last_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Hook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "events": obj.get("events"),
            "config": WebhookConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at"),
            "url": obj.get("url"),
            "test_url": obj.get("test_url"),
            "ping_url": obj.get("ping_url"),
            "deliveries_url": obj.get("deliveries_url"),
            "last_response": HookResponse.from_dict(obj["last_response"]) if obj.get("last_response") is not None else None
        })
        return _obj


