# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.hook_delivery_request import HookDeliveryRequest
from devopso.clients.github.models.hook_delivery_response import HookDeliveryResponse
from typing import Optional, Set
from typing_extensions import Self

class HookDelivery(BaseModel):
    """
    Delivery made by a webhook.
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier of the delivery.")
    guid: StrictStr = Field(description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).")
    delivered_at: datetime = Field(description="Time when the delivery was delivered.")
    redelivery: StrictBool = Field(description="Whether the delivery is a redelivery.")
    duration: Union[StrictFloat, StrictInt] = Field(description="Time spent delivering.")
    status: StrictStr = Field(description="Description of the status of the attempted delivery")
    status_code: StrictInt = Field(description="Status code received when delivery was made.")
    event: StrictStr = Field(description="The event that triggered the delivery.")
    action: Optional[StrictStr] = Field(description="The type of activity for the event that triggered the delivery.")
    installation_id: Optional[StrictInt] = Field(description="The id of the GitHub App installation associated with this event.")
    repository_id: Optional[StrictInt] = Field(description="The id of the repository associated with this event.")
    throttled_at: Optional[datetime] = Field(default=None, description="Time when the webhook delivery was throttled.")
    url: Optional[StrictStr] = Field(default=None, description="The URL target of the delivery.")
    request: HookDeliveryRequest
    response: HookDeliveryResponse
    __properties: ClassVar[List[str]] = ["id", "guid", "delivered_at", "redelivery", "duration", "status", "status_code", "event", "action", "installation_id", "repository_id", "throttled_at", "url", "request", "response"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HookDelivery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of request
        if self.request:
            _dict['request'] = self.request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of response
        if self.response:
            _dict['response'] = self.response.to_dict()
        # set to None if action (nullable) is None
        # and model_fields_set contains the field
        if self.action is None and "action" in self.model_fields_set:
            _dict['action'] = None

        # set to None if installation_id (nullable) is None
        # and model_fields_set contains the field
        if self.installation_id is None and "installation_id" in self.model_fields_set:
            _dict['installation_id'] = None

        # set to None if repository_id (nullable) is None
        # and model_fields_set contains the field
        if self.repository_id is None and "repository_id" in self.model_fields_set:
            _dict['repository_id'] = None

        # set to None if throttled_at (nullable) is None
        # and model_fields_set contains the field
        if self.throttled_at is None and "throttled_at" in self.model_fields_set:
            _dict['throttled_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HookDelivery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "guid": obj.get("guid"),
            "delivered_at": obj.get("delivered_at"),
            "redelivery": obj.get("redelivery"),
            "duration": obj.get("duration"),
            "status": obj.get("status"),
            "status_code": obj.get("status_code"),
            "event": obj.get("event"),
            "action": obj.get("action"),
            "installation_id": obj.get("installation_id"),
            "repository_id": obj.get("repository_id"),
            "throttled_at": obj.get("throttled_at"),
            "url": obj.get("url"),
            "request": HookDeliveryRequest.from_dict(obj["request"]) if obj.get("request") is not None else None,
            "response": HookDeliveryResponse.from_dict(obj["response"]) if obj.get("response") is not None else None
        })
        return _obj


