# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.app_permissions import AppPermissions
from devopso.clients.github.models.repository import Repository
from typing import Optional, Set
from typing_extensions import Self

class InstallationToken(BaseModel):
    """
    Authentication token for a GitHub App installed on a user or org.
    """ # noqa: E501
    token: StrictStr
    expires_at: StrictStr
    permissions: Optional[AppPermissions] = None
    repository_selection: Optional[StrictStr] = None
    repositories: Optional[List[Repository]] = None
    single_file: Optional[StrictStr] = None
    has_multiple_single_files: Optional[StrictBool] = None
    single_file_paths: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["token", "expires_at", "permissions", "repository_selection", "repositories", "single_file", "has_multiple_single_files", "single_file_paths"]

    @field_validator('repository_selection')
    def repository_selection_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['all', 'selected']):
            raise ValueError("must be one of enum values ('all', 'selected')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstallationToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict['permissions'] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in repositories (list)
        _items = []
        if self.repositories:
            for _item_repositories in self.repositories:
                if _item_repositories:
                    _items.append(_item_repositories.to_dict())
            _dict['repositories'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstallationToken from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "token": obj.get("token"),
            "expires_at": obj.get("expires_at"),
            "permissions": AppPermissions.from_dict(obj["permissions"]) if obj.get("permissions") is not None else None,
            "repository_selection": obj.get("repository_selection"),
            "repositories": [Repository.from_dict(_item) for _item in obj["repositories"]] if obj.get("repositories") is not None else None,
            "single_file": obj.get("single_file"),
            "has_multiple_single_files": obj.get("has_multiple_single_files"),
            "single_file_paths": obj.get("single_file_paths")
        })
        return _obj


