# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.author_association import AuthorAssociation
from devopso.clients.github.models.issue_event_dismissed_review import IssueEventDismissedReview
from devopso.clients.github.models.issue_event_label import IssueEventLabel
from devopso.clients.github.models.issue_event_milestone import IssueEventMilestone
from devopso.clients.github.models.issue_event_project_card import IssueEventProjectCard
from devopso.clients.github.models.issue_event_rename import IssueEventRename
from devopso.clients.github.models.nullable_integration import NullableIntegration
from devopso.clients.github.models.nullable_issue import NullableIssue
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class IssueEvent(BaseModel):
    """
    Issue Event
    """ # noqa: E501
    id: StrictInt
    node_id: StrictStr
    url: StrictStr
    actor: Optional[NullableSimpleUser]
    event: StrictStr
    commit_id: Optional[StrictStr]
    commit_url: Optional[StrictStr]
    created_at: datetime
    issue: Optional[NullableIssue] = None
    label: Optional[IssueEventLabel] = None
    assignee: Optional[NullableSimpleUser] = None
    assigner: Optional[NullableSimpleUser] = None
    review_requester: Optional[NullableSimpleUser] = None
    requested_reviewer: Optional[NullableSimpleUser] = None
    requested_team: Optional[Team] = None
    dismissed_review: Optional[IssueEventDismissedReview] = None
    milestone: Optional[IssueEventMilestone] = None
    project_card: Optional[IssueEventProjectCard] = None
    rename: Optional[IssueEventRename] = None
    author_association: Optional[AuthorAssociation] = None
    lock_reason: Optional[StrictStr] = None
    performed_via_github_app: Optional[NullableIntegration] = None
    __properties: ClassVar[List[str]] = ["id", "node_id", "url", "actor", "event", "commit_id", "commit_url", "created_at", "issue", "label", "assignee", "assigner", "review_requester", "requested_reviewer", "requested_team", "dismissed_review", "milestone", "project_card", "rename", "author_association", "lock_reason", "performed_via_github_app"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue
        if self.issue:
            _dict['issue'] = self.issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of label
        if self.label:
            _dict['label'] = self.label.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assignee
        if self.assignee:
            _dict['assignee'] = self.assignee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assigner
        if self.assigner:
            _dict['assigner'] = self.assigner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of review_requester
        if self.review_requester:
            _dict['review_requester'] = self.review_requester.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested_reviewer
        if self.requested_reviewer:
            _dict['requested_reviewer'] = self.requested_reviewer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested_team
        if self.requested_team:
            _dict['requested_team'] = self.requested_team.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dismissed_review
        if self.dismissed_review:
            _dict['dismissed_review'] = self.dismissed_review.to_dict()
        # override the default output from pydantic by calling `to_dict()` of milestone
        if self.milestone:
            _dict['milestone'] = self.milestone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_card
        if self.project_card:
            _dict['project_card'] = self.project_card.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rename
        if self.rename:
            _dict['rename'] = self.rename.to_dict()
        # override the default output from pydantic by calling `to_dict()` of performed_via_github_app
        if self.performed_via_github_app:
            _dict['performed_via_github_app'] = self.performed_via_github_app.to_dict()
        # set to None if actor (nullable) is None
        # and model_fields_set contains the field
        if self.actor is None and "actor" in self.model_fields_set:
            _dict['actor'] = None

        # set to None if commit_id (nullable) is None
        # and model_fields_set contains the field
        if self.commit_id is None and "commit_id" in self.model_fields_set:
            _dict['commit_id'] = None

        # set to None if commit_url (nullable) is None
        # and model_fields_set contains the field
        if self.commit_url is None and "commit_url" in self.model_fields_set:
            _dict['commit_url'] = None

        # set to None if issue (nullable) is None
        # and model_fields_set contains the field
        if self.issue is None and "issue" in self.model_fields_set:
            _dict['issue'] = None

        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if assigner (nullable) is None
        # and model_fields_set contains the field
        if self.assigner is None and "assigner" in self.model_fields_set:
            _dict['assigner'] = None

        # set to None if review_requester (nullable) is None
        # and model_fields_set contains the field
        if self.review_requester is None and "review_requester" in self.model_fields_set:
            _dict['review_requester'] = None

        # set to None if requested_reviewer (nullable) is None
        # and model_fields_set contains the field
        if self.requested_reviewer is None and "requested_reviewer" in self.model_fields_set:
            _dict['requested_reviewer'] = None

        # set to None if lock_reason (nullable) is None
        # and model_fields_set contains the field
        if self.lock_reason is None and "lock_reason" in self.model_fields_set:
            _dict['lock_reason'] = None

        # set to None if performed_via_github_app (nullable) is None
        # and model_fields_set contains the field
        if self.performed_via_github_app is None and "performed_via_github_app" in self.model_fields_set:
            _dict['performed_via_github_app'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "url": obj.get("url"),
            "actor": NullableSimpleUser.from_dict(obj["actor"]) if obj.get("actor") is not None else None,
            "event": obj.get("event"),
            "commit_id": obj.get("commit_id"),
            "commit_url": obj.get("commit_url"),
            "created_at": obj.get("created_at"),
            "issue": NullableIssue.from_dict(obj["issue"]) if obj.get("issue") is not None else None,
            "label": IssueEventLabel.from_dict(obj["label"]) if obj.get("label") is not None else None,
            "assignee": NullableSimpleUser.from_dict(obj["assignee"]) if obj.get("assignee") is not None else None,
            "assigner": NullableSimpleUser.from_dict(obj["assigner"]) if obj.get("assigner") is not None else None,
            "review_requester": NullableSimpleUser.from_dict(obj["review_requester"]) if obj.get("review_requester") is not None else None,
            "requested_reviewer": NullableSimpleUser.from_dict(obj["requested_reviewer"]) if obj.get("requested_reviewer") is not None else None,
            "requested_team": Team.from_dict(obj["requested_team"]) if obj.get("requested_team") is not None else None,
            "dismissed_review": IssueEventDismissedReview.from_dict(obj["dismissed_review"]) if obj.get("dismissed_review") is not None else None,
            "milestone": IssueEventMilestone.from_dict(obj["milestone"]) if obj.get("milestone") is not None else None,
            "project_card": IssueEventProjectCard.from_dict(obj["project_card"]) if obj.get("project_card") is not None else None,
            "rename": IssueEventRename.from_dict(obj["rename"]) if obj.get("rename") is not None else None,
            "author_association": obj.get("author_association"),
            "lock_reason": obj.get("lock_reason"),
            "performed_via_github_app": NullableIntegration.from_dict(obj["performed_via_github_app"]) if obj.get("performed_via_github_app") is not None else None
        })
        return _obj


