# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from devopso.clients.github.models.author_association import AuthorAssociation
from devopso.clients.github.models.issue_dependencies_summary import IssueDependenciesSummary
from devopso.clients.github.models.issue_field_value import IssueFieldValue
from devopso.clients.github.models.issue_pull_request import IssuePullRequest
from devopso.clients.github.models.issue_search_result_item_labels_inner import IssueSearchResultItemLabelsInner
from devopso.clients.github.models.issue_type import IssueType
from devopso.clients.github.models.nullable_integration import NullableIntegration
from devopso.clients.github.models.nullable_milestone import NullableMilestone
from devopso.clients.github.models.nullable_simple_user import NullableSimpleUser
from devopso.clients.github.models.reaction_rollup import ReactionRollup
from devopso.clients.github.models.repository import Repository
from devopso.clients.github.models.search_result_text_matches_inner import SearchResultTextMatchesInner
from devopso.clients.github.models.simple_user import SimpleUser
from devopso.clients.github.models.sub_issues_summary import SubIssuesSummary
from typing import Optional, Set
from typing_extensions import Self

class IssueSearchResultItem(BaseModel):
    """
    Issue Search Result Item
    """ # noqa: E501
    url: StrictStr
    repository_url: StrictStr
    labels_url: StrictStr
    comments_url: StrictStr
    events_url: StrictStr
    html_url: StrictStr
    id: StrictInt
    node_id: StrictStr
    number: StrictInt
    title: StrictStr
    locked: StrictBool
    active_lock_reason: Optional[StrictStr] = None
    assignees: Optional[List[SimpleUser]] = None
    user: Optional[NullableSimpleUser]
    labels: List[IssueSearchResultItemLabelsInner]
    sub_issues_summary: Optional[SubIssuesSummary] = None
    issue_dependencies_summary: Optional[IssueDependenciesSummary] = None
    issue_field_values: Optional[List[IssueFieldValue]] = None
    state: StrictStr
    state_reason: Optional[StrictStr] = None
    assignee: Optional[NullableSimpleUser]
    milestone: Optional[NullableMilestone]
    comments: StrictInt
    created_at: datetime
    updated_at: datetime
    closed_at: Optional[datetime]
    text_matches: Optional[List[SearchResultTextMatchesInner]] = None
    pull_request: Optional[IssuePullRequest] = None
    body: Optional[StrictStr] = None
    score: Union[StrictFloat, StrictInt]
    author_association: AuthorAssociation
    draft: Optional[StrictBool] = None
    repository: Optional[Repository] = None
    body_html: Optional[StrictStr] = None
    body_text: Optional[StrictStr] = None
    timeline_url: Optional[StrictStr] = None
    type: Optional[IssueType] = None
    performed_via_github_app: Optional[NullableIntegration] = None
    reactions: Optional[ReactionRollup] = None
    __properties: ClassVar[List[str]] = ["url", "repository_url", "labels_url", "comments_url", "events_url", "html_url", "id", "node_id", "number", "title", "locked", "active_lock_reason", "assignees", "user", "labels", "sub_issues_summary", "issue_dependencies_summary", "issue_field_values", "state", "state_reason", "assignee", "milestone", "comments", "created_at", "updated_at", "closed_at", "text_matches", "pull_request", "body", "score", "author_association", "draft", "repository", "body_html", "body_text", "timeline_url", "type", "performed_via_github_app", "reactions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueSearchResultItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assignees (list)
        _items = []
        if self.assignees:
            for _item_assignees in self.assignees:
                if _item_assignees:
                    _items.append(_item_assignees.to_dict())
            _dict['assignees'] = _items
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # override the default output from pydantic by calling `to_dict()` of sub_issues_summary
        if self.sub_issues_summary:
            _dict['sub_issues_summary'] = self.sub_issues_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue_dependencies_summary
        if self.issue_dependencies_summary:
            _dict['issue_dependencies_summary'] = self.issue_dependencies_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in issue_field_values (list)
        _items = []
        if self.issue_field_values:
            for _item_issue_field_values in self.issue_field_values:
                if _item_issue_field_values:
                    _items.append(_item_issue_field_values.to_dict())
            _dict['issue_field_values'] = _items
        # override the default output from pydantic by calling `to_dict()` of assignee
        if self.assignee:
            _dict['assignee'] = self.assignee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of milestone
        if self.milestone:
            _dict['milestone'] = self.milestone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in text_matches (list)
        _items = []
        if self.text_matches:
            for _item_text_matches in self.text_matches:
                if _item_text_matches:
                    _items.append(_item_text_matches.to_dict())
            _dict['text_matches'] = _items
        # override the default output from pydantic by calling `to_dict()` of pull_request
        if self.pull_request:
            _dict['pull_request'] = self.pull_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repository
        if self.repository:
            _dict['repository'] = self.repository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of performed_via_github_app
        if self.performed_via_github_app:
            _dict['performed_via_github_app'] = self.performed_via_github_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reactions
        if self.reactions:
            _dict['reactions'] = self.reactions.to_dict()
        # set to None if active_lock_reason (nullable) is None
        # and model_fields_set contains the field
        if self.active_lock_reason is None and "active_lock_reason" in self.model_fields_set:
            _dict['active_lock_reason'] = None

        # set to None if assignees (nullable) is None
        # and model_fields_set contains the field
        if self.assignees is None and "assignees" in self.model_fields_set:
            _dict['assignees'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        # set to None if state_reason (nullable) is None
        # and model_fields_set contains the field
        if self.state_reason is None and "state_reason" in self.model_fields_set:
            _dict['state_reason'] = None

        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if milestone (nullable) is None
        # and model_fields_set contains the field
        if self.milestone is None and "milestone" in self.model_fields_set:
            _dict['milestone'] = None

        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closed_at'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if performed_via_github_app (nullable) is None
        # and model_fields_set contains the field
        if self.performed_via_github_app is None and "performed_via_github_app" in self.model_fields_set:
            _dict['performed_via_github_app'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueSearchResultItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "repository_url": obj.get("repository_url"),
            "labels_url": obj.get("labels_url"),
            "comments_url": obj.get("comments_url"),
            "events_url": obj.get("events_url"),
            "html_url": obj.get("html_url"),
            "id": obj.get("id"),
            "node_id": obj.get("node_id"),
            "number": obj.get("number"),
            "title": obj.get("title"),
            "locked": obj.get("locked"),
            "active_lock_reason": obj.get("active_lock_reason"),
            "assignees": [SimpleUser.from_dict(_item) for _item in obj["assignees"]] if obj.get("assignees") is not None else None,
            "user": NullableSimpleUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "labels": [IssueSearchResultItemLabelsInner.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "sub_issues_summary": SubIssuesSummary.from_dict(obj["sub_issues_summary"]) if obj.get("sub_issues_summary") is not None else None,
            "issue_dependencies_summary": IssueDependenciesSummary.from_dict(obj["issue_dependencies_summary"]) if obj.get("issue_dependencies_summary") is not None else None,
            "issue_field_values": [IssueFieldValue.from_dict(_item) for _item in obj["issue_field_values"]] if obj.get("issue_field_values") is not None else None,
            "state": obj.get("state"),
            "state_reason": obj.get("state_reason"),
            "assignee": NullableSimpleUser.from_dict(obj["assignee"]) if obj.get("assignee") is not None else None,
            "milestone": NullableMilestone.from_dict(obj["milestone"]) if obj.get("milestone") is not None else None,
            "comments": obj.get("comments"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "closed_at": obj.get("closed_at"),
            "text_matches": [SearchResultTextMatchesInner.from_dict(_item) for _item in obj["text_matches"]] if obj.get("text_matches") is not None else None,
            "pull_request": IssuePullRequest.from_dict(obj["pull_request"]) if obj.get("pull_request") is not None else None,
            "body": obj.get("body"),
            "score": obj.get("score"),
            "author_association": obj.get("author_association"),
            "draft": obj.get("draft"),
            "repository": Repository.from_dict(obj["repository"]) if obj.get("repository") is not None else None,
            "body_html": obj.get("body_html"),
            "body_text": obj.get("body_text"),
            "timeline_url": obj.get("timeline_url"),
            "type": IssueType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "performed_via_github_app": NullableIntegration.from_dict(obj["performed_via_github_app"]) if obj.get("performed_via_github_app") is not None else None,
            "reactions": ReactionRollup.from_dict(obj["reactions"]) if obj.get("reactions") is not None else None
        })
        return _obj


