# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from typing_extensions import Annotated
from devopso.clients.github.models.issues_add_labels_request_one_of import IssuesAddLabelsRequestOneOf
from devopso.clients.github.models.issues_set_labels_request_one_of1 import IssuesSetLabelsRequestOneOf1
from devopso.clients.github.models.issues_set_labels_request_one_of1_labels_inner import IssuesSetLabelsRequestOneOf1LabelsInner
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ISSUESADDLABELSREQUEST_ONE_OF_SCHEMAS = ["IssuesAddLabelsRequestOneOf", "IssuesSetLabelsRequestOneOf1", "List[IssuesSetLabelsRequestOneOf1LabelsInner]", "List[str]", "str"]

class IssuesAddLabelsRequest(BaseModel):
    """
    IssuesAddLabelsRequest
    """
    # data type: IssuesAddLabelsRequestOneOf
    oneof_schema_1_validator: Optional[IssuesAddLabelsRequestOneOf] = None
    # data type: List[str]
    oneof_schema_2_validator: Optional[Annotated[List[StrictStr], Field(min_length=1)]] = None
    # data type: IssuesSetLabelsRequestOneOf1
    oneof_schema_3_validator: Optional[IssuesSetLabelsRequestOneOf1] = None
    # data type: List[IssuesSetLabelsRequestOneOf1LabelsInner]
    oneof_schema_4_validator: Optional[Annotated[List[IssuesSetLabelsRequestOneOf1LabelsInner], Field(min_length=1)]] = None
    # data type: str
    oneof_schema_5_validator: Optional[StrictStr] = None
    actual_instance: Optional[Union[IssuesAddLabelsRequestOneOf, IssuesSetLabelsRequestOneOf1, List[IssuesSetLabelsRequestOneOf1LabelsInner], List[str], str]] = None
    one_of_schemas: Set[str] = { "IssuesAddLabelsRequestOneOf", "IssuesSetLabelsRequestOneOf1", "List[IssuesSetLabelsRequestOneOf1LabelsInner]", "List[str]", "str" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = IssuesAddLabelsRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: IssuesAddLabelsRequestOneOf
        if not isinstance(v, IssuesAddLabelsRequestOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IssuesAddLabelsRequestOneOf`")
        else:
            match += 1
        # validate data type: List[str]
        try:
            instance.oneof_schema_2_validator = v
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # validate data type: IssuesSetLabelsRequestOneOf1
        if not isinstance(v, IssuesSetLabelsRequestOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IssuesSetLabelsRequestOneOf1`")
        else:
            match += 1
        # validate data type: List[IssuesSetLabelsRequestOneOf1LabelsInner]
        try:
            instance.oneof_schema_4_validator = v
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # validate data type: str
        try:
            instance.oneof_schema_5_validator = v
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in IssuesAddLabelsRequest with oneOf schemas: IssuesAddLabelsRequestOneOf, IssuesSetLabelsRequestOneOf1, List[IssuesSetLabelsRequestOneOf1LabelsInner], List[str], str. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in IssuesAddLabelsRequest with oneOf schemas: IssuesAddLabelsRequestOneOf, IssuesSetLabelsRequestOneOf1, List[IssuesSetLabelsRequestOneOf1LabelsInner], List[str], str. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into IssuesAddLabelsRequestOneOf
        try:
            instance.actual_instance = IssuesAddLabelsRequestOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into List[str]
        try:
            # validation
            instance.oneof_schema_2_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.oneof_schema_2_validator
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IssuesSetLabelsRequestOneOf1
        try:
            instance.actual_instance = IssuesSetLabelsRequestOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into List[IssuesSetLabelsRequestOneOf1LabelsInner]
        try:
            # validation
            instance.oneof_schema_4_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.oneof_schema_4_validator
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into str
        try:
            # validation
            instance.oneof_schema_5_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.oneof_schema_5_validator
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into IssuesAddLabelsRequest with oneOf schemas: IssuesAddLabelsRequestOneOf, IssuesSetLabelsRequestOneOf1, List[IssuesSetLabelsRequestOneOf1LabelsInner], List[str], str. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into IssuesAddLabelsRequest with oneOf schemas: IssuesAddLabelsRequestOneOf, IssuesSetLabelsRequestOneOf1, List[IssuesSetLabelsRequestOneOf1LabelsInner], List[str], str. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], IssuesAddLabelsRequestOneOf, IssuesSetLabelsRequestOneOf1, List[IssuesSetLabelsRequestOneOf1LabelsInner], List[str], str]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


