# coding: utf-8

"""
    GitHub v3 REST API

    GitHub's v3 REST API.

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.github.models.issues_create_request_labels_inner import IssuesCreateRequestLabelsInner
from devopso.clients.github.models.issues_create_request_milestone import IssuesCreateRequestMilestone
from devopso.clients.github.models.issues_create_request_title import IssuesCreateRequestTitle
from typing import Optional, Set
from typing_extensions import Self

class IssuesCreateRequest(BaseModel):
    """
    IssuesCreateRequest
    """ # noqa: E501
    title: IssuesCreateRequestTitle
    body: Optional[StrictStr] = Field(default=None, description="The contents of the issue.")
    assignee: Optional[StrictStr] = Field(default=None, description="Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is closing down.**_")
    milestone: Optional[IssuesCreateRequestMilestone] = None
    labels: Optional[List[IssuesCreateRequestLabelsInner]] = Field(default=None, description="Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._")
    assignees: Optional[List[StrictStr]] = Field(default=None, description="Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._")
    type: Optional[StrictStr] = Field(default=None, description="The name of the issue type to associate with this issue. _NOTE: Only users with push access can set the type for new issues. The type is silently dropped otherwise._")
    __properties: ClassVar[List[str]] = ["title", "body", "assignee", "milestone", "labels", "assignees", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuesCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of title
        if self.title:
            _dict['title'] = self.title.to_dict()
        # override the default output from pydantic by calling `to_dict()` of milestone
        if self.milestone:
            _dict['milestone'] = self.milestone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        # set to None if assignee (nullable) is None
        # and model_fields_set contains the field
        if self.assignee is None and "assignee" in self.model_fields_set:
            _dict['assignee'] = None

        # set to None if milestone (nullable) is None
        # and model_fields_set contains the field
        if self.milestone is None and "milestone" in self.model_fields_set:
            _dict['milestone'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuesCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": IssuesCreateRequestTitle.from_dict(obj["title"]) if obj.get("title") is not None else None,
            "body": obj.get("body"),
            "assignee": obj.get("assignee"),
            "milestone": IssuesCreateRequestMilestone.from_dict(obj["milestone"]) if obj.get("milestone") is not None else None,
            "labels": [IssuesCreateRequestLabelsInner.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "assignees": obj.get("assignees"),
            "type": obj.get("type")
        })
        return _obj


